package com.artfess.cqxy.search.dao;

import java.util.List;

import com.artfess.cqxy.processManagermant.model.ProgressManage;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;


/**
 * 档案全局检索表(BizGlobalRetrieval)表数据库访问层
 *
 * @author 黎沐华
 * @since 2022-03-22 13:13:32
 */
public interface GlobalRetrievalDao extends BaseMapper<GlobalRetrieval> {

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<GlobalRetrieval> queryAllByPage(IPage<GlobalRetrieval> convert2IPage, @Param(Constants.WRAPPER) Wrapper<GlobalRetrieval> convert2Wrapper);

    GlobalRetrieval geByBizId(@Param("bizId") String bizId);

    int remove(@Param("type") Integer type,@Param("id") String id);

    int update(@Param("data") GlobalRetrieval data);

}

