package com.artfess.cqxy.projectManagement.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.baomidou.mybatisplus.extension.service.IService;
import com.artfess.cqxy.projectManagement.model.DirectoryManagement;

import java.util.List;

/**
 * 目录管理表(BizDirectoryManagement)表服务接口
 * @author 黎沐华
 * @since 2022-02-16 09:04:12
 */
public interface DirectoryManagementManager extends BaseManager<DirectoryManagement> {

    /**
     * 根据父节点ID获取其子节点数据
     * @param pCode 父节点ID
     * @return 树状数据
     */
    List<DirectoryManagement> getByParentId(String pCode);

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 数据集合
     */
    PageList<DirectoryManagement> queryChildNodeByPage(QueryFilter<DirectoryManagement> queryFilter);

    /**
     * 更改父节点是否有子节点的装填
     * @param data QueryWrapper更新数据对象
     * @param flag 更改标志 true 有 false 无
     */
    void changeHasChildNode(DirectoryManagement data,boolean flag);

}

