package com.artfess.cqxy.projectApproval.dao;

import java.util.List;
import java.util.Map;

import com.artfess.cqxy.bidManagement.model.BidManagement;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.artfess.cqxy.statistics.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import com.artfess.cqxy.projectApproval.model.ProjectEstablishment;

/**
 * 项目立项表(BizProjectEstablishment)表数据库访问层
 * @author 黎沐华
 * @since 2022-02-14 15:30:49
 */
public interface ProjectEstablishmentDao extends BaseMapper<ProjectEstablishment> {

    /**
     * 通过ID获取数据，关联项目信息，不能使用原生查询
     * @param id ID
     * @return 一条数据
     */
    ProjectEstablishment getById(@Param("id") String id);

    /**
     * 分页查询所有数据
     * @param convert2IPage 分页对象
     * @param convert2Wrapper 查询参数
     * @return 数据集合
     */
    IPage<ProjectEstablishment> queryAllByPage(IPage<ProjectEstablishment> convert2IPage, @Param(Constants.WRAPPER) Wrapper<ProjectEstablishment> convert2Wrapper);


    /**
     * 根据条件查询建设情况
     * @param statisticsVo
     * @return
     */
    List<Map<String, Object>> queryInvestment(@Param("statisticsVo") StatisticsVo statisticsVo);

    String getMoneyByPid(@Param("id") String id);
}

