package com.artfess.cqxy.ledger.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqxy.contract.model.Contract;
import com.artfess.cqxy.ledger.manager.ApprovalLedgerManager;
import com.artfess.cqxy.ledger.manager.ContractLedgerManager;
import com.artfess.cqxy.ledger.vo.ContractKeeperVo;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;

/**
 * @author Limuhua
 * @date 2022/3/18 11:27
 */
@Slf4j
@RestController
@Api(tags = "台账-合同台账接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("/biz/ledger/contractLedger/v1")
public class ContractLedgerController {

    @Autowired
    private ContractLedgerManager manager;

    /**
     * 分页查询所有数据
     * @param queryFilter 通用查询器
     * @return 分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询所有数据", httpMethod = "POST")
    public CommonResult<Map<String, Object>> page(@ApiParam(name = "queryFilter",value = "项目管理查询器") @RequestBody QueryFilter<Contract> queryFilter) {
        Map<String, Object> result = manager.queryByPage(queryFilter);
        return new CommonResult<>(true, "操作成功", result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "S-导出数据到Excel",notes = "合同查询器")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<Contract> queryFilter, HttpServletResponse response) throws IOException {
        log.debug("导出数据到Excel接口请求参数：{}",queryFilter,response);
        manager.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }


    /**
     * 根据合同ID修改合同经办人
     * @param contractKeeperVo
     * @return 分页数据
     */
    @PostMapping("/updateContractReceiverById")
    @ApiOperation(value = "S-修改合同经办人", httpMethod = "POST")
    public CommonResult<String> updateContractReceiverById(@ApiParam(name = "queryFilter",value = "项目管理查询器") @RequestBody ContractKeeperVo contractKeeperVo) {
        manager.updateContractReceiverById(contractKeeperVo);
        return new CommonResult<String>(true, "数据修改成功！", contractKeeperVo.getId());
    }
}
