package com.artfess.cqxy.documentLibrary.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cqxy.documentLibrary.dao.FileLibraryTypeDao;
import com.artfess.cqxy.documentLibrary.manager.FileLibraryTypeManager;
import com.artfess.cqxy.documentLibrary.model.FileLibraryType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 文件库-分类表(FileLibraryType)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-04-02 09:21:22
 */
@Service
public class FileLibraryTypeManagerImpl extends BaseManagerImpl<FileLibraryTypeDao, FileLibraryType> implements FileLibraryTypeManager {

    @Override
    public void changeHasChildNode(String typeID, boolean flag) {
        int num = flag ?
                baseMapper.updateChildNodeStatus(typeID, "0") :
                baseMapper.updateChildNodeStatus(typeID, "1");
    }

    @Override
    public List<FileLibraryType> getByParentCode(String pCode) {
        return traversalTree(baseMapper.getByParentCode(pCode));
    }

    private List<FileLibraryType> traversalTree(List<FileLibraryType> list) {
        List<FileLibraryType> trees = new ArrayList<>();
        if(!list.isEmpty()){
            for (FileLibraryType tree : list) {
                List<FileLibraryType> children = traversalTree(baseMapper.getByParentCode(tree.getCode()));
                tree.setChildren(children);
                trees.add(tree);
            }
        }
        return trees;
    }

    @Override
    public boolean isKeyExist(String id, String code) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq("CODE_", code);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(id)){
            wrapper.ne("ID_", id);
        }
        Integer integer = baseMapper.selectCount(wrapper);
        if(integer > 0){
            return true;
        }
        return false;
    }

    @Override
    public PageList<FileLibraryType> queryChildNodeByPage(QueryFilter<FileLibraryType> queryFilter) {
        // 限制父节点编码不能为空
        String pCode = null;
        List<QueryField> test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if ("bflt.PCODE_".equals(ele.getProperty())) {
                pCode = String.valueOf(ele.getValue());
                break;
            }
        }
        Assert.notNull(pCode, "父节点编码不能为空！");
        queryFilter.addFilter("bflt.IS_DELE_", "0", QueryOP.EQUAL);
        IPage<FileLibraryType> result =
                baseMapper.queryChildNodeByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));

        return new PageList<>(result);
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        List<FileLibraryType> data = baseMapper.selectBatchIds(idList);
        boolean flag = super.removeByIds(idList);
        for (FileLibraryType ele : data) {
            if (getByParentCode(ele.getPcode()).size() == 0) {
                changeHasChildNode(ele.getId(), false);
            }
        }
        return flag;
    }

    @Override
    public boolean checkHasChild(String id) {
        Integer flag = baseMapper.selectById(id).getHasChildren();
        return 0 == flag;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<FileLibraryType> entityList) {
        boolean result = false;
        if (null == entityList || entityList.size() == 0) {
            return false;
        }
        for (FileLibraryType ele : entityList) {
            FileLibraryType flag = baseMapper.selectOne(new QueryWrapper<FileLibraryType>().eq("IS_DELE_", "0").eq("CODE_", ele.getCode()));
            if (null != flag && !StringUtils.isEmpty(flag.getCode())) {
                throw new RuntimeException("节点编码已经存在！");
            }
            result = save(ele);
            // 新增时添加到父节点，要改变父节点的hasChildren状态
            changeHasChildNode(ele.getId(), true);
        }
        return result;
    }

}

