package com.artfess.cqxy.completionAcceptance.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.completionAcceptance.dao.AcceptanceFinalAccountsDao;
import com.artfess.cqxy.completionAcceptance.manager.AcceptanceFinalAccountsManager;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceFinalAccounts;
import com.artfess.cqxy.completionAcceptance.model.AcceptanceSettlement;
import com.artfess.cqxy.contract.manager.ContractManager;
import com.artfess.cqxy.projectApproval.model.DecisionAnnualPlan;
import com.artfess.cqxy.projectApproval.model.DecisionBasis;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 竣工验收 - 决算表(BizAcceptanceFinalAccounts)表服务实现类
 *
 * @author 黎沐华
 * @since 2022-03-07 15:52:29
 */
@Service
public class AcceptanceFinalAccountsManagerImpl extends BaseManagerImpl<AcceptanceFinalAccountsDao, AcceptanceFinalAccounts> implements AcceptanceFinalAccountsManager{

    @Autowired
    private AccessoryManager accessoryManager;

    @Autowired
    private ProjectManagementManager pm;

    @Autowired
    private GlobalRetrievalManager grm;

    @Autowired
    private ContractManager cm;

    @Autowired
    private BaseContext baseContext;

    @Override
    public boolean saveOrUpdate(AcceptanceFinalAccounts entity) {
        boolean save = StringUtils.isEmpty(entity.getId());
        boolean savedMain = super.saveOrUpdate(entity);
        // 处理附件信息
        List<Accessory> flag = entity.getAccessoryInfo();//处理空指针
        List<Accessory> accessoryList = null == flag ? new ArrayList<>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.eleven.getCode());
            ele.setGroup("AcceptanceFinalAccounts");
            ele.setNode(ProjectStatusEnum.eleven.getCode());
            ele.setCreateBy(baseContext.getCurrentUserId());
            ele.setCreateName(baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        // 先清空该ID下的所有附件信息再添加
        accessoryManager.removeBySourceId(entity.getId());
        // 如果没有附件则返回true，不进入添加
        boolean saveAcc = accessoryList.size() == 0 || accessoryManager.saveAccess(accessoryList);
        //更新项目状态
        pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.forteen.getCode()));
        // 同步到检索表
        GlobalRetrieval globalRetrieval= grm.getByBizId(entity.getId());
        handleRetrieval(save || BeanUtils.isEmpty(globalRetrieval) ?new GlobalRetrieval():globalRetrieval,entity);

        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, AcceptanceFinalAccounts entity){
        ProjectManagement projectManagement = pm.getById(entity.getProjectId());
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentySix.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentySix.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentySix.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentySix.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentySix.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentySix.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentySix.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentySix.getFunctionPath());
        globalRetrieval.setSearchTitle(entity.getFinalAccountsOpinions()+"_"+entity.getApprovalOpinion()+"_"+entity.getRemarks());
        grm.saveOrUpdate(globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        // 同步删除检索表中的信息
        for(String ele:ids){
            grm.remove(1,ele);
        }
        return removeByIds(ids);
    }

    @Override
    public AcceptanceFinalAccounts getById(String id) {
        AcceptanceFinalAccounts result = baseMapper.getById(id);
        result.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<AcceptanceFinalAccounts> queryAllByPage(QueryFilter<AcceptanceFinalAccounts> queryFilter) {
        queryFilter.addFilter("bafa.IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("pm.VALID_FLAG_", 1, QueryOP.EQUAL);
        IPage<AcceptanceFinalAccounts> result =
                baseMapper.queryAllByPage(
                        convert2IPage(queryFilter.getPageBean()),
                        convert2Wrapper(queryFilter, currentModelClass()));
        // 附件信息处理
        List<AcceptanceFinalAccounts> records = result.getRecords();
        for (AcceptanceFinalAccounts ele : records) {
            ele.setAccessoryInfo(accessoryManager.getAccessoryBySourceId(ele.getId()));
        }

        return new PageList<>(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId, String contractId, String contractName) {
        Assert.notNull(projectId, "项目ID不能为空");
        Assert.notNull(contractId, "合同ID不能为空");
        Assert.notNull(contractName, "合同名称不能为空");
        try(InputStream inputStream = file.getInputStream();) {
            // 获取数据
            List<AcceptanceFinalAccounts> data = ExcelImportUtil.importExcel(inputStream,AcceptanceFinalAccounts.class,new ImportParams());
            for(AcceptanceFinalAccounts ele:data){
                ele.setProjectId(projectId);
                ele.setContractId(contractId);
                ele.setCreateName(contractName);
                // 保存数据 & 同步到检索表
                save(ele);
                handleRetrieval(new GlobalRetrieval(),ele);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDataToExcel(QueryFilter<AcceptanceFinalAccounts> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "竣工验收-决算-导出结果";
        // 获取数据
        BizUtils.handleFilter(queryFilter, "bafa", true);
        List<AcceptanceFinalAccounts> data = baseMapper.queryAllByPage(
                        convert2IPage(new PageBean(0, -1, false)),
                        convert2Wrapper(queryFilter, currentModelClass())).
                getRecords();
        if(null==data||data.size()==0){
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName += ".xlsx";

        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, AcceptanceFinalAccounts.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper<AcceptanceFinalAccounts> wrapper = new UpdateWrapper<AcceptanceFinalAccounts>()
                .set(StringUtils.isNotBlank(newProjectId), "PROJECT_ID_", newProjectId)
                .in("PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update(wrapper);
    }
}

