/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.feasiblePlan.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqxy.feasiblePlan.dao.PlanningEngineeringDao;
import com.artfess.cqxy.feasiblePlan.manager.PlanningEngineeringManager;
import com.artfess.cqxy.feasiblePlan.model.PlanningEngineering;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PlanningEngineeringManagerImpl
extends BaseManagerImpl<PlanningEngineeringDao, PlanningEngineering>
implements PlanningEngineeringManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private SysDictionaryManager sdm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ProjectManagementManager pmm;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(PlanningEngineering entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.four.getCode());
            ele.setGroup("PlanningEngineering");
            ele.setNode(ProjectStatusEnum.four.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pmm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.four.getCode()));
        ProjectManagement projectManagement = (ProjectManagement)this.pmm.get((Serializable)((Object)entity.getProjectId()));
        if (null != projectManagement) {
            if (StringUtils.isNotBlank((CharSequence)entity.getProposedLocation())) {
                projectManagement.setProjectAddress(entity.getProposedLocation());
            }
            if (StringUtils.isNotBlank((CharSequence)entity.getConstructionScale())) {
                projectManagement.setProjectContent(entity.getConstructionScale());
            }
            this.pmm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, PlanningEngineering entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pmm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.eight.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.eight.getName());
        globalRetrieval.setBizTableName(FunctionEnum.eight.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.eight.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.eight.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.eight.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.eight.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.eight.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setDocumentUnit(entity.getEstablishmentApprovalUnit());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getDocumentNumber() + "_" + entity.getEstablishmentApprovalUnit() + "_" + entity.getConstructionProjectName() + "_" + entity.getProposedLocation() + "_" + entity.getConstructionScale() + "_" + entity.getEstablishmentRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public PlanningEngineering getById(String id) {
        PlanningEngineering result = ((PlanningEngineeringDao)this.baseMapper).getById(id);
        result.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(id));
        return result;
    }

    @Override
    public PageList<PlanningEngineering> queryAllByPage(QueryFilter<PlanningEngineering> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bpe", "pm");
        IPage<PlanningEngineering> result = ((PlanningEngineeringDao)this.baseMapper).queryAllByPage((IPage<PlanningEngineering>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<PlanningEngineering>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (PlanningEngineering ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        List type = this.sdm.queryDictListItemsByCode("gcgh-lx");
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, PlanningEngineering.class, (ImportParams)new ImportParams());
            for (PlanningEngineering ele : data) {
                ele.setProjectId(projectId);
                ele.setType(BizUtils.getDicCodeByValue(type, ele.getType()));
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<PlanningEngineering> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u89c4\u5212\u8bb8\u53ef.\u5de5\u7a0b\u89c4\u5212-\u5bfc\u51fa\u7ed3\u679c";
        List engineeringType = this.sdm.queryDictListItemsByCode("gcgh-lx");
        BizUtils.handleFilter(queryFilter, "bpe", "pm");
        List data = ((PlanningEngineeringDao)this.baseMapper).queryAllByPage((IPage<PlanningEngineering>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<PlanningEngineering>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (PlanningEngineering ele : data) {
            ele.setType(BizUtils.getDicValueByCode((List<DictModel>)engineeringType, ele.getType()));
        }
        ExportParams exportParams = BizUtils.getExportParams(fileName);
        fileName = fileName + ".xlsx";
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, PlanningEngineering.class, (Collection)data);
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

