/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqxy.completionAcceptance.manager.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.cqxy.completionAcceptance.dao.RecordAcceptanceDao;
import com.artfess.cqxy.completionAcceptance.manager.RecordAcceptanceManager;
import com.artfess.cqxy.completionAcceptance.model.RecordAcceptance;
import com.artfess.cqxy.projectManagement.enums.ProjectStatusEnum;
import com.artfess.cqxy.projectManagement.manager.ProjectManagementManager;
import com.artfess.cqxy.projectManagement.model.ProjectManagement;
import com.artfess.cqxy.search.enums.FunctionEnum;
import com.artfess.cqxy.search.manager.GlobalRetrievalManager;
import com.artfess.cqxy.search.model.GlobalRetrieval;
import com.artfess.cqxy.universal.manager.AccessoryManager;
import com.artfess.cqxy.universal.model.Accessory;
import com.artfess.cqxy.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RecordAcceptanceManagerImpl
extends BaseManagerImpl<RecordAcceptanceDao, RecordAcceptance>
implements RecordAcceptanceManager {
    @Autowired
    private AccessoryManager accessoryManager;
    @Autowired
    private ProjectManagementManager pm;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private GlobalRetrievalManager grm;

    public boolean saveOrUpdate(RecordAcceptance entity) {
        boolean save = StringUtils.isEmpty((CharSequence)entity.getId());
        boolean savedMain = super.saveOrUpdate((Object)entity);
        ArrayList<Accessory> flag = entity.getAccessoryInfo();
        ArrayList<Accessory> accessoryList = null == flag ? new ArrayList<Accessory>() : flag;
        for (Accessory ele : accessoryList) {
            ele.setSourceId(entity.getId());
            ele.setProjectId(entity.getProjectId());
            ele.setDirectory(ProjectStatusEnum.ten.getCode());
            ele.setGroup("RecordAcceptance");
            ele.setNode(ProjectStatusEnum.ten.getCode());
            ele.setCreateBy(this.baseContext.getCurrentUserId());
            ele.setCreateName(this.baseContext.getCurrentUserName());
            ele.setCreateTime(LocalDateTime.now());
        }
        this.accessoryManager.removeBySourceId(entity.getId());
        boolean saveAcc = accessoryList.size() == 0 || this.accessoryManager.saveAccess(accessoryList);
        this.pm.updateStatusById(entity.getProjectId(), Integer.valueOf(ProjectStatusEnum.twelve.getCode()));
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        if (null != projectManagement && null != entity.getCompletionAcceptanceDate()) {
            projectManagement.setCompletionAcceptanceTime(entity.getCompletionAcceptanceDate());
            this.pm.updateById((Object)projectManagement);
        }
        GlobalRetrieval globalRetrieval = this.grm.getByBizId(entity.getId());
        this.handleRetrieval(save || BeanUtils.isEmpty((Object)((Object)globalRetrieval)) ? new GlobalRetrieval() : globalRetrieval, entity);
        return savedMain && saveAcc;
    }

    private void handleRetrieval(GlobalRetrieval globalRetrieval, RecordAcceptance entity) {
        ProjectManagement projectManagement = (ProjectManagement)((Object)this.pm.getById((Serializable)((Object)entity.getProjectId())));
        globalRetrieval.setProjectId(entity.getProjectId());
        globalRetrieval.setProjectName(projectManagement.getProjectName());
        globalRetrieval.setPersonCharge(projectManagement.getProjectManager());
        globalRetrieval.setArchivesType(1);
        globalRetrieval.setBizDataId(entity.getId());
        globalRetrieval.setFunctionCode(FunctionEnum.twentyFour.getCode());
        globalRetrieval.setFunctionName(FunctionEnum.twentyFour.getName());
        globalRetrieval.setBizTableName(FunctionEnum.twentyFour.getTableName());
        globalRetrieval.setDetailsRoteUrl(FunctionEnum.twentyFour.getTableRoteUrl());
        globalRetrieval.setTableRoteUrl(FunctionEnum.twentyFour.getTableRoteUrl());
        globalRetrieval.setTableApiUrl(FunctionEnum.twentyFour.getTableApiUrl());
        globalRetrieval.setDetailsApiUrl(FunctionEnum.twentyFour.getDetailsApiUrl());
        globalRetrieval.setFunctionPath(FunctionEnum.twentyFour.getFunctionPath());
        globalRetrieval.setDocumentNumber(entity.getDocumentNumber());
        globalRetrieval.setName(entity.getName());
        globalRetrieval.setSearchTitle(entity.getName() + "_" + entity.getDocumentNumber() + "_" + entity.getCompletionAcceptanceOpinions() + "_" + entity.getCompletionProjectName() + "_" + entity.getCompletionAcceptanceRegistrant() + "_" + entity.getApprovalFilingAuthority() + "_" + entity.getApprovalUnitFilingAuthority() + "_" + entity.getApprovalOpinion() + "_" + entity.getRemarks());
        this.grm.saveOrUpdate((Object)globalRetrieval);
    }

    @Override
    public boolean deleteByIds(List<String> ids) {
        for (String ele : ids) {
            this.grm.remove(1, ele);
        }
        return this.removeByIds(ids);
    }

    @Override
    public RecordAcceptance getById(String id) {
        return ((RecordAcceptanceDao)this.baseMapper).getById(id);
    }

    @Override
    public PageList<RecordAcceptance> queryAllByPage(QueryFilter<RecordAcceptance> queryFilter) {
        BizUtils.handleFilter(queryFilter, "bra", false);
        IPage<RecordAcceptance> result = ((RecordAcceptanceDao)this.baseMapper).queryAllByPage((IPage<RecordAcceptance>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<RecordAcceptance>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        for (RecordAcceptance ele : records) {
            ele.setAccessoryInfo(this.accessoryManager.getAccessoryBySourceId(ele.getId()));
        }
        return new PageList(result);
    }

    @Override
    public void importExcelData(MultipartFile file, String projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
        String projectName = ((ProjectManagement)this.pm.get((Serializable)((Object)projectId))).getProjectName();
        try (InputStream inputStream = file.getInputStream();){
            List data = ExcelImportUtil.importExcel((InputStream)inputStream, RecordAcceptance.class, (ImportParams)new ImportParams());
            for (RecordAcceptance ele : data) {
                ele.setProjectId(projectId);
                ele.setCompletionProjectName(projectName);
                this.save((Object)ele);
                this.handleRetrieval(new GlobalRetrieval(), ele);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void exportDatatoExcel(QueryFilter<RecordAcceptance> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "\u7ae3\u5de5\u9a8c\u6536-\u8054\u5408\u5907\u6848\u9a8c\u6536-\u5bfc\u51fa\u7ed3\u679c";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(fileName);
        ArrayList<String> heards = new ArrayList<String>();
        heards.addAll(Arrays.asList("\u9879\u76ee\u540d\u79f0", "\u7ae3\u5de5\u9a8c\u6536\u65e5\u671f", "\u5907\u6848\u673a\u5173\u5ba1\u6279\u5355\u4f4d", "\u5907\u6848\u673a\u5173\u5ba1\u6279\u65e5\u671f", "\u7ae3\u5de5\u9a8c\u6536\u610f\u89c1", "\u7ae3\u5de5\u9a8c\u6536\u5907\u6848\u767b\u8bb0\u4eba", "\u5907\u6ce8"));
        HSSFRow titleRow1 = sheet.createRow(0);
        for (int i = 0; i < heards.size(); ++i) {
            BizUtils.handelCell(workbook, fileName, titleRow1.createCell(i), (String)heards.get(i), new boolean[0]);
        }
        int row = 1;
        BizUtils.handleFilter(queryFilter, "bra", false);
        List data = ((RecordAcceptanceDao)this.baseMapper).queryAllByPage((IPage<RecordAcceptance>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<RecordAcceptance>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u8981\u5bfc\u51fa\u7684\u7684\u6570\u636e\uff01");
        }
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow listRow = sheet.createRow(row);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(0), ((RecordAcceptance)((Object)data.get(i))).getProjectInfo().getProjectName(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(1), DateUtils.date2Str((Date)((RecordAcceptance)((Object)data.get(i))).getCompletionAcceptanceDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd")), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(2), ((RecordAcceptance)((Object)data.get(i))).getApprovalUnitFilingAuthority(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(3), DateUtils.date2Str((Date)((RecordAcceptance)((Object)data.get(i))).getApprovalFilingAuthorityDate(), (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd")), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(4), ((RecordAcceptance)((Object)data.get(i))).getCompletionAcceptanceOpinions(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(5), ((RecordAcceptance)((Object)data.get(i))).getCompletionAcceptanceRegistrant(), new boolean[0]);
            BizUtils.handelCell(workbook, fileName, listRow.createCell(6), ((RecordAcceptance)((Object)data.get(i))).getRemarks(), new boolean[0]);
            ++row;
        }
        sheet.setColumnWidth(0, 7000);
        ExcelUtil.downloadExcel((HSSFWorkbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    @Override
    public void updateProjectIdByProiectId(String oldProjectIds, String newProjectId) {
        UpdateWrapper wrapper = (UpdateWrapper)new UpdateWrapper().set(StringUtils.isNotBlank((CharSequence)newProjectId), "PROJECT_ID_", (Object)newProjectId).in((Object)"PROJECT_ID_", Arrays.asList(oldProjectIds.split(",")));
        this.update((Wrapper)wrapper);
    }
}

