package com.artfess.sysConfig.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.artfess.sysConfig.persistence.dao.AppTagsRelationDao;
import com.artfess.sysConfig.persistence.manager.AppTagsRelationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.model.AppTagsRelation;
import com.artfess.sysConfig.persistence.model.SysApp;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 应用标签关系表 服务实现类
 *
 * @company 广州宏天软件股份有限公司
 * @author zst
 * @since 2020-10-12
 */
@Service
public class AppTagsRelationManagerImpl extends BaseManagerImpl<AppTagsRelationDao, AppTagsRelation> implements AppTagsRelationManager {

    @Override
    @Transactional
    public void saveAppTags(String appId, String tagIds) {
        //删除旧数据
        Map<String,Object> conditionMap = new HashMap<>();
        conditionMap.put("APP_ID_",appId);
        baseMapper.deleteByMap(conditionMap);

        String[] ids = tagIds.split(",");
        for (String tagId : ids) {
            AppTagsRelation rel = new AppTagsRelation();
            rel.setAppId(appId);
            rel.setTagId(tagId);
            baseMapper.insert(rel);
        }
    }

    @Override
    public List<AppTagsRelation> getByAppId(String appId) {
        Map<String,Object> condition = new HashMap<>();
        condition.put("APP_ID_",appId);
        return baseMapper.selectByMap(condition);
    }

    @Override
    public Set<String> getAppIdsByTagIds(String[] tagIds) {
        return baseMapper.getAppIdsByTagIds(tagIds).stream().collect(Collectors.toSet());
    }
}
