/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.es.config;

import com.artfess.es.config.ElasticsearchConfig;
import java.util.ArrayList;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={ElasticsearchConfig.class})
public class ElasticsearchRestHighClient {
    @Autowired
    ElasticsearchConfig elasticsearchConfig;

    @Bean
    public RestClientBuilder restClientBuilder() {
        HttpHost[] httpHosts = this.makeHttpHost(this.elasticsearchConfig.getHost());
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])httpHosts);
        String username = this.elasticsearchConfig.getUserName();
        if (!StringUtils.isEmpty((Object)username)) {
            String password = this.elasticsearchConfig.getPassword();
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchRestHighClient.lambda$restClientBuilder$0((CredentialsProvider)credentialsProvider, arg_0));
        }
        return restClientBuilder;
    }

    @Bean(name={"restHighLevelClient"})
    public RestHighLevelClient highLevelClient(RestClientBuilder restClientBuilder) {
        return new RestHighLevelClient(restClientBuilder);
    }

    private HttpHost[] makeHttpHost(String s) {
        String[] address;
        HttpHost[] httpHosts = new HttpHost[]{};
        ArrayList<HttpHost> hostList = new ArrayList<HttpHost>();
        for (String address1 : address = s.split(",")) {
            String temp = address1.trim();
            String[] ipAndPort = temp.split(":");
            if (ipAndPort.length != 2) continue;
            String ip = ipAndPort[0];
            int port = Integer.parseInt(ipAndPort[1]);
            hostList.add(new HttpHost(ip, port, "http"));
        }
        return hostList.toArray(httpHosts);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.disableAuthCaching();
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

