package com.artfess.dataAccess.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.dataAccess.model.DataAccessControl;

import java.util.List;

/**
 * 数据权限——授权 服务类
 *
 * @author llj
 * @since 2021-04-01
 */
public interface DataAccessControlManager extends BaseManager<DataAccessControl> {

    /**
     * @param accessDefinedId 权限定义id
     * @Description: 根据权限定义id查询所有授权
     * @Return:
     * @Author: llj
     * @Date: 2021/4/1 10:26
     */
    List<DataAccessControl> queryListDataAccessDefined(String accessDefinedId);

    /**
     * @param DataAccessControl 授权对象
     * @Description: 保存授权
     * @Return: java.lang.String
     * @Author: llj
     * @Date: 2021/4/1 10:28
     */
    String saveDataAccessDefined(List<DataAccessControl> DataAccessControl);

}
