/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import io.jsonwebtoken.ExpiredJwtException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenUtils {
    private static final Logger log = LoggerFactory.getLogger(TokenUtils.class);

    public static String getTokenByRequest(HttpServletRequest request) {
        String token = request.getParameter("token");
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        try {
            String username;
            if (StringUtil.isNotEmpty(token)) {
                username = jwtTokenHandler.getUsernameFromToken(token);
                if (username == null) {
                    throw new ApplicationException("token\u975e\u6cd5\u65e0\u6548!");
                }
                if (!jwtTokenHandler.isTokenExpired(token).booleanValue()) {
                    token = jwtTokenHandler.refreshToken(token);
                }
            }
            if (token == null && (username = jwtTokenHandler.getUsernameFromToken(token = request.getHeader("X-Access-Token"))) == null) {
                throw new ApplicationException("token\u975e\u6cd5\u65e0\u6548!");
            }
            if (token == null && (username = jwtTokenHandler.getUsernameFromToken(token = jwtTokenHandler.generateFeignToken())) == null) {
                throw new ApplicationException("token\u975e\u6cd5\u65e0\u6548!");
            }
        }
        catch (ExpiredJwtException e) {
            throw new ApplicationException("token\u5df2\u8fc7\u671f!");
        }
        return token;
    }

    public static boolean verifyToken(String token) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApplicationException("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        return jwtTokenHandler.validateFeignToken(token);
    }

    public static boolean verifyToken(HttpServletRequest request) throws Exception {
        log.info(" -- url --" + request.getRequestURL());
        String token = TokenUtils.getTokenByRequest(request);
        if (StringUtils.isBlank((String)token)) {
            throw new ApplicationException("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        String username = jwtTokenHandler.getUsernameFromToken(token);
        if (username == null) {
            throw new ApplicationException("token\u975e\u6cd5\u65e0\u6548!");
        }
        UCFeignService service = AppUtil.getBean(UCFeignService.class);
        JsonNode jsonNode = service.loadUserByUsername(username);
        if (jsonNode == null || jsonNode.isEmpty()) {
            throw new ApplicationException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        int lockedStatus = jsonNode.get("lockedStatus").asInt();
        if (lockedStatus != 1) {
            throw new ApplicationException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        int status = jsonNode.get("status").asInt();
        if (status != 1) {
            throw new ApplicationException("\u8d26\u53f7\u5df2\u88ab\u7981\u7528\u6216\u79bb\u804c!");
        }
        return true;
    }

    public static boolean jwtTokenRefresh(String token) {
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        String refreshedToken = jwtTokenHandler.refreshToken(token);
        return StringUtil.isNotEmpty(refreshedToken);
    }
}

