/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.webSocket.PushService;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.xqxt.meeting.dao.BizMeetingTopicUserDao;
import com.artfess.xqxt.meeting.dao.BizMeetingVoteDao;
import com.artfess.xqxt.meeting.manager.BizMeetingOptionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingQuestionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingTopicManager;
import com.artfess.xqxt.meeting.manager.BizMeetingTopicUserManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.model.BizMeetingOption;
import com.artfess.xqxt.meeting.model.BizMeetingQuestion;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.artfess.xqxt.meeting.model.BizMeetingTopicUser;
import com.artfess.xqxt.meeting.model.BizMeetingVote;
import com.artfess.xqxt.meeting.model.Meeting;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gexin.fastjson.JSON;
import com.google.api.client.util.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.Assert;

@Service
public class BizMeetingVoteManagerImpl
extends BaseManagerImpl<BizMeetingVoteDao, BizMeetingVote>
implements BizMeetingVoteManager {
    private static final Logger log = LoggerFactory.getLogger(BizMeetingVoteManagerImpl.class);
    @Autowired
    private BizMeetingTopicManager topicManager;
    @Autowired
    private BizMeetingQuestionManager questionManager;
    @Autowired
    private BizMeetingOptionManager optionManager;
    @Autowired
    private PushService pushService;
    @Autowired
    private MeetingManager meetingManager;
    @Autowired
    private MeetingUserManager meetingUserManager;
    @Resource
    private BizMeetingTopicUserManager bizMeetingTopicUserManager;
    @Resource
    private BizMeetingTopicUserDao bizMeetingTopicUserDao;
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserManager userManager;
    @Resource
    private BizMeetingVoteManager bizMeetingVoteManager;

    @Override
    public BizMeetingTopic detail(String id) {
        BizMeetingTopic bizMeetingTopic = (BizMeetingTopic)((Object)this.topicManager.getById((Serializable)((Object)id)));
        if (bizMeetingTopic != null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TOPIC_ID_", (Object)id);
            List topicUsers = this.bizMeetingTopicUserManager.list((Wrapper)queryWrapper);
            List userids = topicUsers.stream().map(BizMeetingTopicUser::getUserId).collect(Collectors.toList());
            QueryWrapper userWrapper = new QueryWrapper();
            userWrapper.in((Object)"ID_", userids);
            bizMeetingTopic.setUsers(this.userManager.list((Wrapper)userWrapper));
        }
        return bizMeetingTopic;
    }

    @Override
    public Integer checkTheme(String meetingId, String theme) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        queryWrapper.eq((Object)"TOPIC_CONTENT_", (Object)theme);
        return this.topicManager.list((Wrapper)queryWrapper).size();
    }

    @Override
    public PageList<BizMeetingTopic> selectByUserId(QueryFilter<BizMeetingTopic> queryFilter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        List listQueryField = queryFilter.getQuerys();
        List topicUsers = new ArrayList();
        for (QueryField queryField : listQueryField) {
            if (!"meeting_id_".equals(queryField.getProperty())) continue;
            List<String> meetings = Arrays.asList(queryField.getValue().toString().split(","));
            queryWrapper.in((Object)"MEETING_ID_", meetings);
            queryWrapper.eq((Object)"USER_ID_", (Object)this.baseContext.getCurrentUserId());
            topicUsers = this.bizMeetingTopicUserManager.list((Wrapper)queryWrapper);
            break;
        }
        if (topicUsers.size() > 0) {
            queryFilter.addFilter("ID_", topicUsers.stream().map(BizMeetingTopicUser::getTopicId).collect(Collectors.toList()), QueryOP.IN);
        }
        queryFilter.addFilter("CREATE_BY_", (Object)this.baseContext.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.OR);
        if (this.topicManager.query(queryFilter).getRows().size() > 0) {
            return this.topicManager.query(queryFilter);
        }
        PageList nullList = new PageList();
        nullList.setRows(new ArrayList());
        return nullList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createVote(BizMeetingTopic topic) {
        boolean result = false;
        try {
            Assert.notNull((Object)((Object)topic), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            Assert.notNull((Object)topic.getMeetingId(), (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a!");
            Assert.notEmpty(topic.getQuestionList(), (String)"\u95ee\u9898\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
            topic.getQuestionList().forEach(ql -> Assert.notEmpty(ql.getOptionList(), (String)("\u95ee\u9898\u3010" + ql.getQuestionContent() + "\u3011\u7684\u9009\u9879\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01")));
            ArrayList deleteQuestion = Lists.newArrayList();
            ArrayList deleteOption = Lists.newArrayList();
            this.questionManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"topic_id_", (Object)topic.getId())).forEach(ql -> deleteQuestion.add(ql.getId()));
            if (BeanUtils.isNotEmpty((Object)deleteQuestion)) {
                this.questionManager.removeByIds(deleteQuestion);
                this.optionManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().in((Object)"QUESTION_ID_", (Collection)deleteQuestion)).forEach(ol -> deleteOption.add(ol.getId()));
            }
            if (BeanUtils.isNotEmpty((Object)deleteOption)) {
                this.optionManager.removeByIds(deleteOption);
            }
            if (StringUtil.isEmpty((String)topic.getId()) && null == topic.getStatus()) {
                topic.setStatus(1);
            } else {
                this.bizMeetingTopicUserDao.deleteById(topic.getMeetingId(), topic.getId());
            }
            result = this.topicManager.saveOrUpdate((Object)topic);
            boolean a = false;
            topic.getQuestionList().forEach(ql -> {
                ql.setTopicId(topic.getId());
                ql.setAnonymous(Integer.valueOf(topic.getAnonymous()));
                ql.setMeetingId(topic.getMeetingId());
            });
            result = this.questionManager.saveOrUpdateBatch(topic.getQuestionList());
            ArrayList options = Lists.newArrayList();
            topic.getQuestionList().forEach(ql -> ql.getOptionList().forEach(ol -> {
                if (!ql.getQuestionType().equals(ol.getOptionType())) {
                    throw new RuntimeException("\u95ee\u9898\u3010" + ql.getQuestionContent() + "\u3011\u548c\u9009\u9879\u3010" + ol.getOptionValue() + "\u3011\u7684\u7c7b\u578b\u4e0d\u76f8\u7b26!");
                }
                ol.setQuestionId(ql.getId());
                options.add(ol);
            }));
            result = this.optionManager.saveOrUpdateBatch(options);
            List<String> userIds = Arrays.asList(topic.getUserIds().split(","));
            for (String userId : userIds) {
                BizMeetingTopicUser bizMeetingTopicUser = new BizMeetingTopicUser();
                bizMeetingTopicUser.setMeetingId(topic.getMeetingId());
                bizMeetingTopicUser.setTopicId(topic.getId());
                bizMeetingTopicUser.setUserId(userId);
                bizMeetingTopicUser.setCreateBy(this.baseContext.getCurrentUserId());
                bizMeetingTopicUser.setCreateName(this.baseContext.getCurrentUserName());
                this.bizMeetingTopicUserManager.create((Model)bizMeetingTopicUser);
            }
            this.pushTopic(topic);
        }
        catch (Exception e) {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    @Override
    @Transactional
    public boolean vote(BizMeetingVote vote) {
        Assert.notNull((Object)((Object)vote), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)vote.getQuestionId(), (String)"\u95ee\u9898ID\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)vote.getOptionId(), (String)"\u9009\u9879ID\u4e0d\u80fd\u4e3a\u7a7a!");
        User currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)vote.getUserId()) && BeanUtils.isEmpty((Object)vote.getUserName()) && BeanUtils.isEmpty((Object)vote.getUserAccount()) && BeanUtils.isEmpty((Object)currentUser)) {
            throw new RuntimeException("\u7528\u6237\u5173\u8054\u5f02\u5e38\uff0c\u6ca1\u6709\u53ef\u5173\u8054\u7684\u7528\u6237\u3002");
        }
        if (BeanUtils.isEmpty((Object)vote.getUserId()) || BeanUtils.isEmpty((Object)vote.getUserName()) || BeanUtils.isEmpty((Object)vote.getUserAccount())) {
            log.error("\u6295\u7968\u7528\u6237\u5173\u8054\uff0c\u4f20\u5165\u53c2\u6570userId\u3001userAccount\u3001userName\u4e0d\u5b8c\u5168\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u767b\u5f55\u7528\u6237......");
            vote.setUserId(currentUser.getUserId());
            vote.setUserAccount(currentUser.getAccount());
            vote.setUserName(currentUser.getFullname());
        }
        BizMeetingQuestion question = (BizMeetingQuestion)this.questionManager.get((Serializable)((Object)vote.getQuestionId()));
        int repeatCheck = ((BizMeetingVoteDao)this.baseMapper).selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"QUESTION_ID_", (Object)vote.getQuestionId())).eq((Object)"USER_ID_", (Object)vote.getUserId()));
        if (repeatCheck >= 1) {
            throw new RuntimeException("\u7528\u6237\u3010" + vote.getUserName() + "\u3011\u5df2\u7ecf\u4e3a\u3010" + question.getQuestionContent() + "\u3011\u6295\u8fc7\u7968\u4e86!");
        }
        Assert.notNull((Object)((Object)question), (String)("questionId\u3010" + vote.getQuestionId() + "\u3011\u6ca1\u6709\u6570\u636e!"));
        if ("1".equals(question.getQuestionType()) && vote.getOptionId().split(",").length != 1) {
            throw new RuntimeException("\u4f20\u5165\u7684\u9009\u9879\u957f\u5ea6\u4e0e\u95ee\u9898\u7c7b\u578b\u4e0d\u5339\u914d!");
        }
        boolean result = this.save((Object)vote);
        BizMeetingTopic pushData = (BizMeetingTopic)((Object)this.topicManager.getById((Serializable)((Object)question.getTopicId())));
        this.pushTopic(pushData);
        return result;
    }

    @Override
    public boolean changeVoteStatus(BizMeetingTopic topic) {
        Assert.notNull((Object)((Object)topic), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)topic.getId(), (String)"\u4e3b\u952e ID \u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)topic.getStatus(), (String)"\u72b6\u6001 Status \u4e0d\u80fd\u4e3a\u7a7a!");
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.set((Object)"STATUS_", (Object)topic.getStatus())).eq((Object)"ID_", (Object)topic.getId());
        boolean result = this.topicManager.update((Wrapper)updateWrapper);
        this.pushTopic((BizMeetingTopic)this.topicManager.get((Serializable)((Object)topic.getId())));
        return result;
    }

    @Override
    public Map<String, Boolean> checkUserVote(String topicId) {
        Assert.notNull((Object)topicId, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        BizMeetingTopic topic = (BizMeetingTopic)((Object)this.topicManager.getById((Serializable)((Object)topicId)));
        Assert.notNull((Object)((Object)topic), (String)("\u6ca1\u6709\u627e\u5230topicId\u3010" + topicId + "\u3011\u5bf9\u5e94\u7684\u6570\u636e!"));
        User currentUser = ContextUtil.getCurrentUser();
        List allVote = this.list();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(5);
        topic.getQuestionList().forEach(ql -> {
            long count = allVote.stream().filter(v -> v.getUserId().equals(currentUser.getId()) && v.getQuestionId().equals(ql.getId())).count();
            result.put(ql.getId(), count >= 1L);
        });
        return result;
    }

    private void roleBackCheck(boolean flag) {
        if (!flag) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u56de\u6eda\u4e8b\u52a1......");
        }
    }

    private void pushTopic(BizMeetingTopic topic) {
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("vote", "voteTopic");
        obj.put("msgId", topic.getId());
        obj.put("msgTxt", JSON.toJSONString((Object)((Object)topic)));
        this.pushService.pushMsgToAll(obj.toString());
    }

    @Override
    public void exportDataToExcel(QueryFilter<BizMeetingTopic> queryFilter, HttpServletResponse response) throws IOException {
        Assert.notNull(queryFilter, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5fc5\u987b\u5728querys\u4e2d\u4f20\u5165meetingId\uff01");
        Assert.notNull((Object)queryFilter.getQuerys(), (String)"querys\u4e0d\u80fd\u4e3a\u7a7a\uff01\u5fc5\u987b\u4f20\u5165meetingId\uff01");
        String meetingId = "";
        for (QueryField query : queryFilter.getQuerys()) {
            if (!"meetingId".equalsIgnoreCase(query.getProperty()) || !BeanUtils.isNotEmpty((Object)query.getValue())) continue;
            meetingId = String.valueOf(query.getValue());
            break;
        }
        Assert.notNull((Object)meetingId, (String)"meetingId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Meeting meeting = (Meeting)this.meetingManager.get((Serializable)((Object)meetingId));
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)((Object)meeting)), (String)"\u4f20\u5165\u7684meetingId\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        List originData = this.topicManager.query(queryFilter).getRows();
        JSONArray voteProportion = this.getVoteResult(meetingId);
        List allVote = this.list();
        ArrayList currentMeetingVoteRecord = Lists.newArrayList();
        originData.forEach(od -> {
            od.setMettingTheme(meeting.getTheme());
            od.setAnonymous("0".equals(od.getAnonymous()) ? "\u662f" : "\u5426");
            od.getQuestionList().forEach(q -> {
                q.setQuestionType("1".equals(q.getQuestionType()) ? "\u5355\u9009" : "\u591a\u9009");
                q.getOptionList().forEach(o -> {
                    for (Object v : voteProportion) {
                        JSONObject vp = (JSONObject)v;
                        if (!o.getId().equals(vp.getString("optionId"))) continue;
                        BigDecimal allCount = BigDecimal.valueOf(vp.getDoubleValue("allUserCount"));
                        BigDecimal votedCount = BigDecimal.valueOf(vp.getDoubleValue("votedUserCount"));
                        BigDecimal proportion = votedCount.divide(allCount, 4, 5);
                        o.setProportion(proportion.multiply(new BigDecimal(100)));
                        o.setPoll(votedCount.intValue());
                        break;
                    }
                });
                allVote.forEach(av -> {
                    if (q.getId().equals(av.getQuestionId())) {
                        List<String> optionIds = Arrays.asList(av.getOptionId().split(","));
                        q.getOptionList().forEach(o -> optionIds.forEach(oi -> {
                            if (oi.equals(o.getId())) {
                                av.setOptionValue((StringUtil.isEmpty((String)av.getOptionValue()) ? "" : av.getOptionValue()) + o.getOptionValue() + "\u3001");
                            }
                        }));
                        av.setTopicId(od.getId());
                        av.setOptionValue(av.getOptionValue().substring(0, av.getOptionValue().length() - 1));
                        currentMeetingVoteRecord.add(av);
                    }
                });
            });
        });
        String fileName = "\u4f1a\u8bae\u300e" + meeting.getTheme() + "\u300f\u6295\u7968\u8bb0\u5f55\u5bfc\u51fa\u7ed3\u679c.xlsx";
        XSSFWorkbook workbook = new XSSFWorkbook();
        originData.forEach(d -> {
            XSSFSheet sheet = workbook.createSheet(d.getTopicContent());
            this.createTitle(sheet, (BizMeetingTopic)((Object)d));
            int questionCount = 1;
            Integer currentLine = 5;
            for (BizMeetingQuestion question : d.getQuestionList()) {
                XSSFRow qRow0 = sheet.createRow(currentLine.intValue());
                qRow0.createCell(0).setCellValue("\u95ee\u9898" + questionCount);
                qRow0.createCell(1).setCellValue(question.getQuestionContent());
                this.boldValuesingle(workbook, qRow0.getCell(0));
                currentLine = currentLine + 1;
                XSSFRow qRow1 = sheet.createRow(currentLine.intValue());
                qRow1.createCell(0).setCellValue("\u9009\u9879\u7c7b\u578b");
                qRow1.createCell(1).setCellValue(question.getQuestionType());
                currentLine = currentLine + 1;
                XSSFRow oRow0 = sheet.createRow(currentLine.intValue());
                oRow0.createCell(0).setCellValue("\u9009\u9879");
                oRow0.createCell(1).setCellValue("\u7968\u6570");
                oRow0.createCell(2).setCellValue("\u5360\u6bd4");
                oRow0.createCell(3).setCellValue("\u7528\u6237");
                this.boldValue(sheet.getWorkbook(), oRow0);
                for (BizMeetingOption option : question.getOptionList()) {
                    currentLine = currentLine + 1;
                    XSSFRow oRow1 = sheet.createRow(currentLine.intValue());
                    oRow1.createCell(0).setCellValue(option.getOptionValue());
                    oRow1.createCell(1).setCellValue(String.valueOf(BeanUtils.isEmpty((Object)option.getPoll()) ? 0 : option.getPoll()));
                    oRow1.createCell(2).setCellValue((BeanUtils.isEmpty((Object)option.getProportion()) ? Integer.valueOf(0) : option.getProportion().stripTrailingZeros().toPlainString()) + "%");
                    Integer anonymous = question.getAnonymous();
                    if (0 == anonymous) {
                        oRow1.createCell(3).setCellValue("\u533f\u540d\u6295\u7968");
                        continue;
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"QUESTION_ID_", (Object)option.getQuestionId());
                    queryWrapper.like((Object)"OPTION_ID_", (Object)option.getId());
                    List list = this.bizMeetingVoteManager.list((Wrapper)queryWrapper);
                    if (null == list || list.size() == 0) continue;
                    String names = list.stream().map(BizMeetingVote::getUserName).collect(Collectors.joining("\u3001"));
                    oRow1.createCell(3).setCellValue(names);
                }
                currentLine = currentLine + 2;
                ++questionCount;
            }
            for (int i = 0; i < (d.getQuestionList().size() < 2 ? 2 : d.getQuestionList().size()); ++i) {
                sheet.autoSizeColumn(i);
            }
        });
        ExcelUtil.downloadExcel((Workbook)workbook, (String)fileName, (HttpServletResponse)response);
    }

    private void createTitle(XSSFSheet sheet, BizMeetingTopic d) {
        XSSFRow row0 = sheet.createRow(0);
        row0.createCell(0).setCellValue("\u4f1a\u8bae\u4e3b\u9898");
        row0.createCell(1).setCellValue("\u4f1a\u8bae\u53f7");
        XSSFRow row1 = sheet.createRow(1);
        row1.createCell(0).setCellValue(d.getMettingTheme());
        row1.createCell(1).setCellValue(d.getMeetingId());
        XSSFRow row2 = sheet.createRow(2);
        row2.createCell(0).setCellValue("\u6295\u7968\u4e3b\u9898");
        this.boldValuesingle(sheet.getWorkbook(), row2.getCell(0));
        row2.createCell(1).setCellValue(d.getTopicContent());
        XSSFRow row3 = sheet.createRow(3);
        row3.createCell(0).setCellValue("\u662f\u5426\u533f\u540d");
        row3.createCell(1).setCellValue(d.getAnonymous());
        this.boldValue(sheet.getWorkbook(), row0);
    }

    private void boldValue(XSSFWorkbook workbook, XSSFRow ... row) {
        XSSFCellStyle style = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        style.setFont((Font)font);
        for (int i = 0; i < row.length; ++i) {
            for (int t = 0; t < row[i].getLastCellNum(); ++t) {
                row[i].getCell(t).setCellStyle((CellStyle)style);
            }
        }
    }

    private void boldValuesingle(XSSFWorkbook workbook, XSSFCell cell) {
        XSSFCellStyle style = workbook.createCellStyle();
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        style.setFont((Font)font);
        cell.setCellStyle((CellStyle)style);
    }

    @Override
    public JSONArray getVoteResult(String meetingId) {
        JSONArray result = new JSONArray();
        List allMU = this.meetingUserManager.getBaseMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"MEETING_ID_", (Object)meetingId));
        Integer attendance = allMU.size();
        List allOption = this.optionManager.list();
        List allQuestion = this.questionManager.list();
        ArrayList voteData = Lists.newArrayList();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("meetingId", meetingId);
        ((BizMeetingVoteDao)this.baseMapper).getVotesByMeetingId(params).forEach(d -> Arrays.asList(d.getOptionId().split(",")).forEach(o -> {
            BizMeetingVote voteTemp = null;
            try {
                voteTemp = (BizMeetingVote)((Object)((Object)((Object)BeanUtils.cloneBean((Object)d))));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            voteTemp.setOptionId((String)o);
            voteData.add(voteTemp);
        }));
        Map<String, List<BizMeetingVote>> vots = voteData.stream().collect(Collectors.groupingBy(BizMeetingVote::getOptionId));
        for (Map.Entry<String, List<BizMeetingVote>> v : vots.entrySet()) {
            JSONObject data = new JSONObject();
            allOption.forEach(ao -> {
                if (ao.getId().equals(v.getKey())) {
                    allQuestion.forEach(aq -> {
                        if (aq.getId().equals(ao.getQuestionId())) {
                            data.put("topicId", (Object)aq.getTopicId());
                        }
                    });
                }
            });
            String votedUser = "";
            String votedUserId = "";
            for (BizMeetingVote vv : v.getValue()) {
                votedUser = votedUser + vv.getUserName() + ",";
                votedUserId = votedUserId + vv.getUserId() + ",";
            }
            votedUser = votedUser.substring(0, votedUser.length() - 1);
            votedUserId = votedUserId.substring(0, votedUserId.length() - 1);
            data.put("votedUser", (Object)votedUser);
            data.put("votedUserId", (Object)votedUserId);
            data.put("optionId", (Object)v.getKey());
            data.put("allUserCount", (Object)attendance);
            data.put("votedUserCount", (Object)v.getValue().size());
            result.add((Object)data);
        }
        return result;
    }

    @Override
    public Integer votedCount(String topicId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("topicId", topicId);
        return ((BizMeetingVoteDao)this.baseMapper).getVotesByMeetingId(params).stream().collect(Collectors.groupingBy(BizMeetingVote::getUserId)).size();
    }
}

