/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.kafka;

import cn.hutool.json.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class KafkaProducer {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducer.class);
    @Autowired
    private KafkaTemplate<String, Object> kafkaTemplate;
    public static final String ORG_TOPIC = "basic-org-info";
    public static final String USER_TOPIC = "basic-user-info";
    public static final String ROLE_TOPIC = "basic-userrole-info";
    public static final String TOPIC_GROUP = "consumer-xcjy-user";

    public void send(Object obj, final String topicKey) {
        String obj2String = JSONUtil.toJsonStr((Object)obj);
        log.info("\u51c6\u5907\u53d1\u9001\u6d88\u606f\u4e3a\uff1a{}", (Object)obj2String);
        ListenableFuture future = this.kafkaTemplate.send(topicKey, obj);
        future.addCallback((ListenableFutureCallback)new ListenableFutureCallback<SendResult<String, Object>>(){

            public void onFailure(Throwable throwable) {
                System.out.println("\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                log.error("{} - \u751f\u4ea7\u8005 \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1a{}", (Object)topicKey, (Object)throwable.getMessage());
            }

            public void onSuccess(SendResult<String, Object> stringObjectSendResult) {
                System.out.println("\u53d1\u9001\u6d88\u606f\u6210\u529f");
                log.info("{} - \u751f\u4ea7\u8005 \u53d1\u9001\u6d88\u606f\u6210\u529f\uff1a{}", (Object)topicKey, (Object)stringObjectSendResult.toString());
            }
        });
    }
}

