/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.utils;

import com.aspose.cells.IndividualFontConfigs;
import com.aspose.cells.LoadOptions;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class ExcelToPdfUtil {
    public static void excelToPdf(String sourceFilePath, String desFilePathd) {
        try {
            IndividualFontConfigs configs = new IndividualFontConfigs();
            configs.setFontFolder("/usr/share/fonts/chinese", true);
            LoadOptions loadOptions = new LoadOptions();
            loadOptions.setFontConfigs(configs);
            Workbook wb = new Workbook(sourceFilePath);
            FileOutputStream fileOS = new FileOutputStream(desFilePathd);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setOnePagePerSheet(true);
            pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
            int[] autoDrawSheets = new int[]{3};
            ExcelToPdfUtil.autoDraw(wb, autoDrawSheets);
            int[] showSheets = new int[]{0};
            ExcelToPdfUtil.printSheetPage(wb, showSheets);
            wb.save((OutputStream)fileOS, (SaveOptions)pdfSaveOptions);
            fileOS.flush();
            fileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void excelToPdf(Workbook wb, String desFilePathd) {
        try {
            FileOutputStream fileOS = new FileOutputStream(desFilePathd);
            PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
            pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
            pdfSaveOptions.setOnePagePerSheet(true);
            int[] autoDrawSheets = new int[]{3};
            ExcelToPdfUtil.autoDraw(wb, autoDrawSheets);
            int[] showSheets = new int[]{0};
            ExcelToPdfUtil.printSheetPage(wb, showSheets);
            wb.save((OutputStream)fileOS, (SaveOptions)pdfSaveOptions);
            fileOS.flush();
            fileOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void excelToPdf(String sourceFilePath, String desFilePathd, Boolean showSheet) {
        try {
            File file = new File(sourceFilePath);
            InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            Workbook wb = new Workbook(in);
            if (showSheet.booleanValue()) {
                ExcelToPdfUtil.excelToPdf(wb, desFilePathd);
            } else {
                IndividualFontConfigs configs = new IndividualFontConfigs();
                configs.setFontFolder("/usr/share/fonts/chinese", true);
                LoadOptions loadOptions = new LoadOptions();
                loadOptions.setFontConfigs(configs);
                FileOutputStream fileOS = new FileOutputStream(desFilePathd);
                PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
                pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
                pdfSaveOptions.setOnePagePerSheet(true);
                int[] autoDrawSheets = new int[]{0, 1};
                ExcelToPdfUtil.autoDraw(wb, autoDrawSheets);
                int[] showSheets = new int[]{0, 1};
                ExcelToPdfUtil.printSheetPage(wb, showSheets);
                wb.save((OutputStream)fileOS, (SaveOptions)pdfSaveOptions);
                fileOS.flush();
                fileOS.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void autoDraw(Workbook wb, int[] page) {
        if (null != page && page.length > 0) {
            for (int i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).getHorizontalPageBreaks().clear();
                wb.getWorksheets().get(i).getVerticalPageBreaks().clear();
            }
        }
    }

    public static void printSheetPage(Workbook wb, int[] page) {
        int i;
        for (i = 1; i < wb.getWorksheets().getCount(); ++i) {
            wb.getWorksheets().get(i).setVisible(false);
        }
        if (null == page || page.length == 0) {
            wb.getWorksheets().get(0).setVisible(true);
        } else {
            for (i = 0; i < page.length; ++i) {
                wb.getWorksheets().get(i).setVisible(true);
            }
        }
    }

    public static void main(String[] args) {
        ExcelToPdfUtil.excelToPdf("/Users/lionsong/Downloads/1.xlsx", "/Users/lionsong/Downloads/1.pdf");
    }
}

