/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.open.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.rescue.event.model.BizTrafficControl;
import com.artfess.rescue.open.dto.BaseQueryDTO;
import com.artfess.rescue.open.dto.OpenBaseQueryDTO;
import com.artfess.rescue.open.manager.OpenMonitorManager;
import com.artfess.rescue.open.vo.CallAgentsCountVO;
import com.artfess.rescue.open.vo.ComplaintVO;
import com.artfess.rescue.open.vo.EarlyWarningInfoVO;
import com.artfess.rescue.open.vo.EarlyWarningVO;
import com.artfess.rescue.open.vo.EventCountVO;
import com.artfess.rescue.open.vo.EventTrafficVO;
import com.artfess.rescue.open.vo.MonitoringDataCountVo;
import com.artfess.rescue.open.vo.RankUserVO;
import com.artfess.rescue.open.vo.RoadOrgVO;
import com.artfess.rescue.open.vo.TaskCountVO;
import com.artfess.rescue.open.vo.TaskListVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/open/monitor/v1/"})
@ApiGroup(group={"group_biz_rescue"})
@Api(tags={"\u8fd0\u884c\u76d1\u6d4b-\u9a7e\u9a76\u8231\u76f8\u5173\u670d\u52a1"})
public class OpenMonitorController {
    @Resource
    private OpenMonitorManager monitorManager;

    @PostMapping(value={"/task/count"})
    @ApiOperation(value="\u4efb\u52a1\u7edf\u8ba1", notes="\u4efb\u52a1\u7edf\u8ba1-\u5f53\u65e5\u4e8b\u4ef6\u3001\u6551\u63f4\u60c5\u51b5")
    public CommonResult<TaskCountVO> taskCount(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.getTaskCount(dto);
    }

    @PostMapping(value={"/event/realtime"})
    @ApiOperation(value="\u5b9e\u65f6\u4efb\u52a1\u5217\u8868", notes="\u5b9e\u65f6\u4efb\u52a1\u5217\u8868")
    public CommonResult<List<TaskListVO>> realtimeEvent(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.realtimeEvent(dto);
    }

    @PostMapping(value={"/rank/user"})
    @ApiOperation(value="\u503c\u73ed\u4eba\u5458", notes="\u503c\u73ed\u4eba\u5458")
    public CommonResult<List<RankUserVO>> rankUser(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.rankUser(dto);
    }

    @PostMapping(value={"/early/warning"})
    @ApiOperation(value="\u9884\u8b66\u4fe1\u606f", notes="\u9884\u8b66\u4fe1\u606f")
    public CommonResult<EarlyWarningVO> earlyWarning(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.earlyWarning(dto);
    }

    @PostMapping(value={"/complaint"})
    @ApiOperation(value="\u4e8b\u4ef6\u4fe1\u606f-\u6295\u8bc9\u54a8\u8be2\u7edf\u8ba1", notes="\u4e8b\u4ef6\u4fe1\u606f-\u6295\u8bc9\u54a8\u8be2\u7edf\u8ba1")
    public CommonResult<ComplaintVO> complaint(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.complaint(dto);
    }

    @PostMapping(value={"/event/count"})
    @ApiOperation(value="\u4e8b\u4ef6\u4fe1\u606f-\u4e8b\u4ef6\u603b\u89c8", notes="\u4e8b\u4ef6\u4fe1\u606f-\u4e8b\u4ef6\u603b\u89c8\u7edf\u8ba1")
    public CommonResult<EventCountVO> eventCount(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.eventCount(dto);
    }

    @PostMapping(value={"/event/traffic"})
    @ApiOperation(value="\u7ba1\u5236\u60c5\u51b5", notes="\u7ba1\u5236\u60c5\u51b5")
    public CommonResult<EventTrafficVO> eventTraffic(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.eventTraffic(dto);
    }

    @PostMapping(value={"/traffic/control"})
    @ApiOperation(value="\u7ba1\u5236\u8be6\u60c5", notes="\u7ba1\u5236\u8be6\u60c5")
    public CommonResult<List<BizTrafficControl>> trafficControl(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.controlList(dto);
    }

    @PostMapping(value={"/disaster/warning"})
    @ApiOperation(value="\u707e\u5bb3\u9884\u8b66\u4fe1\u606f", notes="\u707e\u5bb3\u9884\u8b66\u4fe1\u606f")
    public CommonResult<List<EarlyWarningInfoVO>> disasterWarning(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.earlyWarningInfos(dto, "disaster");
    }

    @PostMapping(value={"/weather/warning"})
    @ApiOperation(value="\u6c14\u8c61\u9884\u8b66\u4fe1\u606f", notes="\u6c14\u8c61\u9884\u8b66\u4fe1\u606f")
    public CommonResult<List<EarlyWarningInfoVO>> weatherWarning(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.earlyWarningInfos(dto, "weather");
    }

    @PostMapping(value={"/trafficFlow/warning"})
    @ApiOperation(value="\u8f66\u6d41\u91cf\u9884\u8b66\u4fe1\u606f", notes="\u8f66\u6d41\u91cf\u9884\u8b66\u4fe1\u606f")
    public CommonResult<List<EarlyWarningInfoVO>> trafficFlowWarning(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.earlyWarningInfos(dto, "trafficFlow");
    }

    @PostMapping(value={"/getRoad"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7ID\u67e5\u8be2\u5173\u8054\u7684\u8def\u6bb5\u4fe1\u606f", notes="\u8def\u6bb5\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public Set<RoadOrgVO> getRoad(@ApiParam(name="orgId", value="\u7ec4\u7ec7\u6570\u5f53\u524d\u8282\u70b9\u7684ID") @RequestParam String orgId) {
        return this.monitorManager.getRoad(orgId);
    }

    @PostMapping(value={"/call/agents"})
    @ApiOperation(value="\u67e5\u8be2\u547c\u53eb\u5ea7\u5e2d\u8868\u7edf\u8ba1", notes="\u547c\u53eb\u5ea7\u5e2d\u8868\u7edf\u8ba1\u8be6\u60c5")
    public CommonResult<CallAgentsCountVO> getCallAgents(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.getCallAgents(dto);
    }

    @PostMapping(value={"/roadTask/count"})
    @ApiOperation(value="\u9053\u8def\u8fd0\u884c\u76d1\u6d4b\u7edf\u8ba1", notes="\u4efb\u52a1\u7edf\u8ba1-\u9053\u8def\u8fd0\u884c\u76d1\u6d4b\u7edf\u8ba1")
    public CommonResult<MonitoringDataCountVo> roadTaskCount(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody OpenBaseQueryDTO dto) {
        return this.monitorManager.getRoadTaskCount(dto);
    }

    @PostMapping(value={"/common/info"})
    @ApiOperation(value="\u8fd0\u884c\u76d1\u6d4b\u5927\u5c4f-\u660e\u7ec6\u67e5\u8be2", notes="\u8fd0\u884c\u76d1\u6d4b\u5927\u5c4f-\u660e\u7ec6\u67e5\u8be2")
    public PageList roadTaskInfo(@ApiParam(name="OpenBaseQueryDTO", value="\u9a7e\u9a76\u8231\u67e5\u8be2\u6761\u4ef6DTO") @RequestBody BaseQueryDTO dto) {
        return this.monitorManager.getCommonInfo(dto);
    }
}

