/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.mqtt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.rescue.mqtt.model.MqttServerConfig;
import com.artfess.rescue.mqtt.service.MqttConfigService;
import com.artfess.rescue.video.dto.GetTopicInfoRequest;
import com.artfess.rescue.video.util.ArtemisRequest;
import com.artfess.rescue.video.util.HkArtemisRequest;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MqttConfigServiceImpl
implements MqttConfigService {
    private static final Logger log = LoggerFactory.getLogger(MqttConfigServiceImpl.class);
    private final HkArtemisRequest hkArtemisRequest;
    private final ArtemisRequest artemisRequest;
    private static final Long GPS_ID = 5201158145L;
    private static final int QOS = 1;
    @Value(value="${mqtt.enabled}")
    private boolean mqttEnabled;

    @Autowired
    public MqttConfigServiceImpl(HkArtemisRequest hkArtemisRequest, ArtemisRequest artemisRequest) {
        this.hkArtemisRequest = hkArtemisRequest;
        this.artemisRequest = artemisRequest;
        log.info("MqttConfigServiceImpl \u521d\u59cb\u5316\u5b8c\u6210");
    }

    @Override
    public boolean isMqttEnabled() {
        return this.mqttEnabled;
    }

    @Override
    public List<MqttServerConfig> fetchMqttConfigurations() {
        ArrayList<MqttServerConfig> mqttServerConfigs = new ArrayList<MqttServerConfig>();
        try {
            GetTopicInfoRequest topicInfoRequest = new GetTopicInfoRequest();
            ArrayList<Long> eventTypes = new ArrayList<Long>();
            eventTypes.add(GPS_ID);
            topicInfoRequest.setEventTypes(eventTypes);
            String topicInfo = this.artemisRequest.getTopicInfo(topicInfoRequest);
            log.info("\u8def\u7f51\u5730\u5740:{}", (Object)topicInfo);
            MqttServerConfig mqttServerConfig = this.getMqttServerConfig(topicInfo);
            if (mqttServerConfig != null) {
                String host = "tcp://172.16.1.2:1883";
                mqttServerConfig.setServerUrl(host);
                mqttServerConfigs.add(mqttServerConfig);
            }
            String hkTopicInfo = this.hkArtemisRequest.getTopicInfo(topicInfoRequest);
            log.info("\u6d77\u5eb7\u5730\u5740:{}", (Object)hkTopicInfo);
            MqttServerConfig hkMqttServerConfig = this.getMqttServerConfig(hkTopicInfo);
            if (hkMqttServerConfig != null) {
                mqttServerConfigs.add(hkMqttServerConfig);
            }
            return mqttServerConfigs;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6 MQTT \u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private MqttServerConfig getMqttServerConfig(String topicInfo) {
        JSONObject jsonResult = JSONObject.parseObject((String)topicInfo);
        if ("0".equals(jsonResult.getString("code"))) {
            JSONObject data = jsonResult.getJSONObject("data");
            String topicName = data.getJSONObject("topicName").getString(GPS_ID + "");
            String serverUrl = data.getString("host");
            return new MqttServerConfig(serverUrl, data.getString("clientId"), topicName, data.getString("userName"), data.getString("password"), 1);
        }
        return null;
    }
}

