/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.integrate.consts;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.rescue.base.model.BizBaseBridge;
import com.artfess.rescue.base.model.BizBaseCulvert;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseRoadsideFacilities;
import com.artfess.rescue.base.model.BizBaseRoute;
import com.artfess.rescue.base.model.BizBaseSideSlope;
import com.artfess.rescue.base.model.BizBaseTunnel;
import com.artfess.rescue.integrate.config.YhxtConfig;
import com.artfess.rescue.integrate.enums.YhxtEnum;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class YhxtConsts {
    @Autowired
    private YhxtConfig yhxtConfig;

    public String getToken() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("account", this.yhxtConfig.getUserKey());
        String url = "http://" + this.yhxtConfig.getUrl() + ":" + this.yhxtConfig.getPort() + YhxtEnum.TOKEN_URL.getValue();
        try {
            String resultJson = HttpUtil.get((String)url, map);
            JSONObject jsonObject = JSONObject.parseObject((String)resultJson);
            return jsonObject.get((Object)"token").toString();
        }
        catch (BaseException e) {
            throw new BaseException("\u8bf7\u6c42token\u5931\u8d25");
        }
    }

    public List<BizBaseRoute> getRoute() {
        return this.getDataByPath(YhxtEnum.ROUTE_URL.getValue(), BizBaseRoute.class);
    }

    public List<BizBaseRoad> getRoad() {
        return this.getDataByPath(YhxtEnum.ROAD_URL.getValue(), BizBaseRoad.class);
    }

    public List<BizBaseBridge> getBridge() {
        return this.getDataByPath(YhxtEnum.BRIDGE_URL.getValue(), BizBaseBridge.class);
    }

    public List<BizBaseTunnel> getTunnel() {
        return this.getDataByPath(YhxtEnum.TUNNEL_URL.getValue(), BizBaseTunnel.class);
    }

    public List<BizBaseSideSlope> getSideSlope() {
        return this.getDataByPath(YhxtEnum.SIDE_SLOPE_URL.getValue(), BizBaseSideSlope.class);
    }

    public List<BizBaseRoadsideFacilities> getRoadSideFacilities() {
        return this.getDataByPath(YhxtEnum.ROAD_SIDE_FACILITIES_URL.getValue(), BizBaseRoadsideFacilities.class);
    }

    public List<BizBaseCulvert> getCulvert() {
        return this.getDataByPath(YhxtEnum.CULVERT_URL.getValue(), BizBaseCulvert.class);
    }

    private List<?> getDataByPath(String url, Class<?> clazz) {
        String token = this.getToken();
        String fullUrl = "http://" + this.yhxtConfig.getUrl() + ":" + this.yhxtConfig.getPort() + url;
        String result = ((HttpRequest)HttpRequest.get((String)fullUrl).header("Authorization", "Bearer " + token)).timeout(-1).execute().body();
        try {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                JSONArray list = jsonResp.getJSONArray("value");
                if (list.isEmpty()) {
                    throw new BaseException("\u672a\u83b7\u53d6\u5230\u76f8\u5173\u4fe1\u606f");
                }
                return list.toJavaList(clazz);
            }
            throw new BaseException("\u83b7\u53d6\u6570\u636e\u5931\u8d25");
        }
        catch (JSONException e) {
            throw new BaseException("JSON\u89e3\u6790\u9519\u8bef", (Throwable)e);
        }
    }
}

