/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.vo.OrgRoadVO;
import com.artfess.rescue.base.vo.RoadConfigVO;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizBaseRoad/v1/"})
@Api(tags={"\u8def\u6bb5\u4fe1\u606f"})
@ApiGroup(group={"group_biz_rescue"})
public class BizBaseRoadController
extends BaseController<BizBaseRoadManager, BizBaseRoad> {
    @Resource
    RescueOrgManager orgManager;

    @RequestMapping(value={"SynchronizeData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u540c\u6b65\u6570\u636e", httpMethod="GET", notes="\u540c\u6b65\u6570\u636e")
    public CommonResult<String> SynchronizeData() {
        ((BizBaseRoadManager)this.baseService).SynchronizeData();
        return new CommonResult("\u540c\u6b65\u6210\u529f");
    }

    @GetMapping(value={"/roadTree"})
    @ApiOperation(value="\u8def\u6bb5\u6811\u7ed3\u6784", httpMethod="GET", notes="\u8def\u6bb5\u7ba1\u7406\u6570\u636e\u8be6\u60c5")
    public List<OrgRoadVO> roadTree() {
        return ((BizBaseRoadManager)this.baseService).roadTree();
    }

    @PostMapping(value={"/updateConfig"})
    @ApiOperation(value="\u6839\u636e\u8def\u6bb5id\u66f4\u65b0\u8def\u6bb5\u5de1\u67e5\u914d\u7f6e")
    public CommonResult<String> updateConfig(@ApiParam(name="model", value="\u8def\u6bb5\u5de1\u67e5\u914d\u7f6e\u4fe1\u606f") @RequestBody RoadConfigVO t) {
        ((BizBaseRoadManager)this.baseService).updateConfig(t);
        return new CommonResult("\u914d\u7f6e\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/getConfig/{id}"})
    @ApiOperation(value="\u6839\u636e\u8def\u6bb5id\u67e5\u8be2\u8def\u6bb5\u5de1\u67e5\u914d\u7f6e")
    public RoadConfigVO getConfig(@ApiParam(name="id", value="\u8def\u6bb5id") @PathVariable String id) {
        return ((BizBaseRoadManager)this.baseService).getConfig(id);
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<BizBaseRoad> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizBaseRoad> queryFilter) {
        List roadList = this.orgManager.roadTree().stream().map(OrgInfoVO::getRoadList).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList roadIds = new ArrayList();
        if (roadList.isEmpty()) {
            return new PageList();
        }
        for (List roads : roadList) {
            List ids = roads.stream().map(BizBaseRoad::getId).filter(Objects::nonNull).collect(Collectors.toList());
            roadIds.addAll(ids);
        }
        queryFilter.addFilter("ID_", roadIds, QueryOP.IN);
        return ((BizBaseRoadManager)this.baseService).queryInfoPage(queryFilter);
    }
}

