/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.monitor.aop;

import com.alibaba.fastjson.JSONObject;
import com.artfess.rescue.monitor.aop.WebSocketNotify;
import com.artfess.rescue.monitor.eunms.RefreshType;
import com.artfess.rescue.monitor.utils.MessageUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class WebSocketNotificationAspect {
    private static final Logger log = LoggerFactory.getLogger(WebSocketNotificationAspect.class);

    @Around(value="@annotation(webSocketNotify)")
    public Object processSendMessage(ProceedingJoinPoint joinPoint, WebSocketNotify webSocketNotify) throws Throwable {
        RefreshType topic = webSocketNotify.topic();
        String operateType = webSocketNotify.operateType();
        Object result = joinPoint.proceed();
        JSONObject successData = new JSONObject();
        successData.put("status", (Object)"SUCCESS");
        MessageUtil.sendWebSocketMessage(topic.toString(), operateType, successData);
        return result;
    }
}

