/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.external.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.config.UploadResult;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.base.manager.BizBaseRoadManager;
import com.artfess.rescue.base.manager.BizBaseTeamManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTeam;
import com.artfess.rescue.event.manager.BizRescueCarManager;
import com.artfess.rescue.event.manager.BizRescueCostManager;
import com.artfess.rescue.event.manager.BizRescueDispatchManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.manager.BizRescueInfoManager;
import com.artfess.rescue.event.model.BizRescueCar;
import com.artfess.rescue.event.model.BizRescueCost;
import com.artfess.rescue.event.model.BizRescueDispatch;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.event.model.BizRescueInfo;
import com.artfess.rescue.external.enums.CaseCarTypeEnum;
import com.artfess.rescue.external.enums.DirectionEnum;
import com.artfess.rescue.external.enums.LaneOccupationEnum;
import com.artfess.rescue.external.enums.LocationSourceEnum;
import com.artfess.rescue.external.enums.OrderStatusEnum;
import com.artfess.rescue.external.enums.RescueNodeEnum;
import com.artfess.rescue.external.manager.BizDataReceiveManager;
import com.artfess.rescue.external.manager.ReceiveRescueManager;
import com.artfess.rescue.external.model.ApiResponse;
import com.artfess.rescue.external.model.BizDataReceive;
import com.artfess.rescue.external.model.RescueNode;
import com.artfess.rescue.external.model.RescueNodeFile;
import com.artfess.rescue.external.model.RescueOrder;
import com.artfess.rescue.external.utils.ConvertUtils;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public class ReceiveRescueManagerImpl
implements ReceiveRescueManager {
    private static final Logger log = LoggerFactory.getLogger(ReceiveRescueManagerImpl.class);
    @Resource
    private BizRescueInfoManager bizRescueInfoManager;
    @Resource
    private BizRescueCarManager bizRescueCarManager;
    @Resource
    private BizRescueDispatchManager bizRescueDispatchManager;
    @Resource
    private BizRescueCostManager bizRescueCostManager;
    @Resource
    private BizRescueHandleManager bizRescueHandleManager;
    @Resource
    private FileManager fileManager;
    @Resource
    private BizDataReceiveManager bizDataReceiveManager;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private BizBaseRoadManager bizBaseRoadManager;
    @Resource
    private BizBaseTeamManager bizBaseTeamManager;
    private static final String CQ_ORG_ID = "1766017472697475072";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<RescueOrder> updateRescue(RescueOrder rescueOrder) {
        if (ObjectUtils.isEmpty((Object)rescueOrder)) {
            return new ApiResponse<RescueOrder>(HttpStatus.INTERNAL_SERVER_ERROR, "\u6570\u636e\u5f02\u5e38\uff01", rescueOrder);
        }
        BizDataReceive dataReceive = new BizDataReceive();
        dataReceive.setContent(JSONObject.toJSONString((Object)rescueOrder));
        dataReceive.setSourceSystem("\u9633\u5149\u6551\u63f4");
        dataReceive.setBusinessType("\u6551\u63f4\u5de5\u5355\u4fe1\u606f\u540c\u6b65\u63a5\u53e3");
        dataReceive.setReceiveTime(LocalDateTime.now());
        try {
            LambdaQueryWrapper queryWrapper;
            BizRescueInfo bizRescueInfo = (BizRescueInfo)((Object)this.bizRescueInfoManager.getById((Serializable)((Object)rescueOrder.getOrderId())));
            if (Objects.isNull((Object)bizRescueInfo)) {
                bizRescueInfo = new BizRescueInfo();
                bizRescueInfo.setId(rescueOrder.getOrderId());
                bizRescueInfo.setOrderId(rescueOrder.getOrderId());
                String rescueNo = this.sysIdentityManager.nextId("jydjh");
                bizRescueInfo.setRescueNo(rescueNo);
                LambdaQueryWrapper roadQueryWrapper = new LambdaQueryWrapper();
                roadQueryWrapper.eq(BizBaseRoad::getCode, (Object)rescueOrder.getSectionCode());
                roadQueryWrapper.like(BizBaseRoad::getCompanyIds, (Object)CQ_ORG_ID);
                List roads = this.bizBaseRoadManager.list((Wrapper)roadQueryWrapper);
                if (CollectionUtils.isEmpty((Collection)roads)) {
                    dataReceive.setProcessStatus(2);
                    dataReceive.setErrorMessage("\u5de5\u5355\u8f6c\u6362\u5931\u8d25\uff0c\u8def\u6bb5\u7f16\u7801\u65e0\u6cd5\u5339\u914d\uff0cSectionCode\uff1a" + rescueOrder.getSectionCode());
                    ApiResponse<RescueOrder> apiResponse = new ApiResponse<RescueOrder>(HttpStatus.OK, "\u64cd\u4f5c\u6210\u529f\uff01", rescueOrder);
                    return apiResponse;
                }
                BizBaseRoad road = (BizBaseRoad)((Object)roads.get(0));
                bizRescueInfo.setRoadId(road.getId());
                bizRescueInfo.setRoadName(road.getName());
                bizRescueInfo.setRoadCode(road.getCode());
                LambdaQueryWrapper teamQueryWrapper = new LambdaQueryWrapper();
                teamQueryWrapper.eq(BizBaseTeam::getName, (Object)rescueOrder.getTeamName());
                List teams = this.bizBaseTeamManager.list((Wrapper)teamQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)teams)) {
                    bizRescueInfo.setTeamId(((BizBaseTeam)((Object)teams.get(0))).getId());
                }
                bizRescueInfo.setTeamName(rescueOrder.getTeamName());
            }
            if (StringUtil.isNotEmpty((String)rescueOrder.getOrderCaseType())) {
                Integer rescueType = Integer.valueOf(rescueOrder.getOrderCaseType());
                if (rescueType == 1) {
                    bizRescueInfo.setRescueType(2);
                } else if (rescueType == 2) {
                    bizRescueInfo.setRescueType(1);
                }
            }
            bizRescueInfo.setCarCode(rescueOrder.getCaseCarNum());
            Map<Integer, Integer> carTypeMap = CaseCarTypeEnum.getCarClassAndTypeByCode(rescueOrder.getCaseCarType());
            if (carTypeMap != null && !carTypeMap.isEmpty()) {
                Map.Entry<Integer, Integer> entry = carTypeMap.entrySet().iterator().next();
                bizRescueInfo.setCarClass(entry.getKey());
                bizRescueInfo.setCarType(entry.getValue());
            }
            bizRescueInfo.setCarWeight(rescueOrder.getCaeCarWeight() != null ? Double.valueOf(rescueOrder.getCaeCarWeight().longValue()) : null);
            bizRescueInfo.setRescueTel(rescueOrder.getCaseTel());
            bizRescueInfo.setRescueTime(ConvertUtils.convertToLocalDateTime(rescueOrder.getCaseHappenTime()));
            bizRescueInfo.setCarUserTel(rescueOrder.getCaseTel());
            bizRescueInfo.setLat(rescueOrder.getCaseLat() != null ? String.valueOf(rescueOrder.getCaseLat()) : null);
            bizRescueInfo.setLng(rescueOrder.getCaseLng() != null ? String.valueOf(rescueOrder.getCaseLng()) : null);
            bizRescueInfo.setRescueSrc(LocationSourceEnum.getTypeByCode(rescueOrder.getCaseSource()));
            bizRescueInfo.setPegVal(ReceiveRescueManagerImpl.getPegVal(rescueOrder.getStake()));
            bizRescueInfo.setDirection(DirectionEnum.getXcCodeByCode(rescueOrder.getDirection()));
            bizRescueInfo.setOccupy(LaneOccupationEnum.getXcCodeByCode(rescueOrder.getJeeves()));
            bizRescueInfo.setCarWeight(rescueOrder.getCaeCarWeight() != null ? Double.valueOf(rescueOrder.getCaeCarWeight().longValue()) : null);
            bizRescueInfo.setRescueStatus(OrderStatusEnum.getXcCodeByCode(rescueOrder.getOrderStatus()));
            this.bizRescueInfoManager.saveOrUpdate((Object)bizRescueInfo);
            if (StringUtil.isNotEmpty((String)rescueOrder.getMissionCarNum())) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BizRescueCar::getRescueId, (Object)bizRescueInfo.getId());
                this.bizRescueCarManager.remove((Wrapper)queryWrapper);
                BizRescueCar car = new BizRescueCar();
                car.setRescueId(bizRescueInfo.getId());
                car.setDispatchCarCode(rescueOrder.getMissionCarNum());
                car.setDispatchCarType(rescueOrder.getMissionCarType() != null ? String.valueOf(rescueOrder.getMissionCarType()) : null);
                car.setDispatchTime(ConvertUtils.convertToLocalDateTime(rescueOrder.getMissionBeginTime()));
                if (car.getDispatchTime() != null) {
                    car.setDispatchTime(ConvertUtils.convertToLocalDateTime(rescueOrder.getCaseHappenTime()));
                }
                this.bizRescueCarManager.save((Object)car);
            }
            if (StringUtil.isNotEmpty((String)rescueOrder.getMissionPeopleName())) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BizRescueDispatch::getRescueId, (Object)bizRescueInfo.getId());
                this.bizRescueDispatchManager.remove((Wrapper)queryWrapper);
                BizRescueDispatch dispatch = new BizRescueDispatch();
                dispatch.setRescueId(bizRescueInfo.getId());
                dispatch.setDispatchUserId(rescueOrder.getMissionPeopleName());
                dispatch.setDispatchUserName(rescueOrder.getMissionPeopleName());
                dispatch.setDispatchUserTel(rescueOrder.getMissionPeopleTel());
                dispatch.setDispatchTime(ConvertUtils.convertToLocalDateTime(rescueOrder.getMissionBeginTime()));
                this.bizRescueDispatchManager.save((Object)dispatch);
            }
            if (StringUtil.isNotEmpty((String)rescueOrder.getPayMoney())) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(BizRescueCost::getRescueId, (Object)bizRescueInfo.getId());
                this.bizRescueCostManager.remove((Wrapper)queryWrapper);
                BizRescueCost cost = new BizRescueCost();
                cost.setRescueId(bizRescueInfo.getId());
                cost.setCostType(OrderStatusEnum.EMPTY.getCode().equals(rescueOrder.getOrderStatus()) ? "2" : "1");
                cost.setTrailingMileage(rescueOrder.getMileage() != null ? (double)rescueOrder.getMileage().longValue() : 0.0);
                cost.setTotalMileage(rescueOrder.getStartMileage() != null ? (double)rescueOrder.getStartMileage().longValue() : 0.0);
                cost.setNightHomeWork(0);
                cost.setDangerousGoods(0);
                cost.setTunnelWork(0);
                cost.setTrafficAccident(0);
                cost.setShouldMoney(rescueOrder.getPayMoney() != null ? Double.valueOf(rescueOrder.getPayMoney()) : null);
                cost.setActualMoney(rescueOrder.getPayRealMoney() != null ? Double.valueOf(rescueOrder.getPayRealMoney()) : null);
                cost.setCostTime(rescueOrder.getPayTime() != null ? LocalDateTime.ofInstant(rescueOrder.getPayTime().toInstant(), ZoneId.systemDefault()) : null);
                cost.setCarType(bizRescueInfo.getCarType());
                this.bizRescueCostManager.save((Object)cost);
            }
            dataReceive.setProcessStatus(1);
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u5de5\u5355\u4fe1\u606f\u540c\u6b65\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            ApiResponse<RescueOrder> apiResponse = new ApiResponse<RescueOrder>(HttpStatus.INTERNAL_SERVER_ERROR, "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef\uff01", rescueOrder);
            return apiResponse;
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new ApiResponse<RescueOrder>(HttpStatus.OK, "\u64cd\u4f5c\u6210\u529f\uff01", rescueOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<RescueNode> addDoRescue(RescueNode rescueNode) {
        if (ObjectUtils.isEmpty((Object)rescueNode)) {
            return new ApiResponse<RescueNode>(HttpStatus.INTERNAL_SERVER_ERROR, "\u6570\u636e\u5f02\u5e38\uff01", rescueNode);
        }
        BizDataReceive dataReceive = new BizDataReceive();
        dataReceive.setContent(JSONObject.toJSONString((Object)rescueNode));
        dataReceive.setSourceSystem("\u9633\u5149\u6551\u63f4");
        dataReceive.setBusinessType("\u6551\u63f4\u8fc7\u7a0b\u4fe1\u606f\u540c\u6b65");
        dataReceive.setReceiveTime(LocalDateTime.now());
        try {
            String orderId = rescueNode.getOrderId();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BizRescueInfo::getOrderId, (Object)orderId);
            BizRescueInfo bizRescueInfo = (BizRescueInfo)((Object)this.bizRescueInfoManager.getOne((Wrapper)queryWrapper));
            if (Objects.isNull((Object)bizRescueInfo)) {
                throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
            }
            BizRescueHandle rescueHandle = new BizRescueHandle();
            rescueHandle.setNodeId(rescueNode.getId());
            rescueHandle.setRescueId(bizRescueInfo.getId());
            rescueHandle.setRescueNode(RescueNodeEnum.getXcCodeByName(rescueNode.getProcessName()));
            rescueHandle.setHandleUserId(rescueNode.getProcessUser());
            rescueHandle.setHandleUserName(rescueNode.getProcessUser());
            rescueHandle.setHandleTeamId(bizRescueInfo.getTeamId());
            rescueHandle.setHandleTeamId(bizRescueInfo.getTeamName());
            rescueHandle.setHandleTime(ConvertUtils.convertToLocalDateTime(rescueNode.getProcessTime()));
            rescueHandle.setHandleInfo(rescueNode.getProcessContent());
            rescueHandle.setHandleLat(rescueNode.getLat() != null ? String.valueOf(rescueNode.getLat()) : null);
            rescueHandle.setHandleLng(rescueNode.getLng() != null ? String.valueOf(rescueNode.getLng()) : null);
            this.bizRescueHandleManager.save((Object)rescueHandle);
            dataReceive.setProcessStatus(1);
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            ApiResponse<RescueNode> apiResponse = new ApiResponse<RescueNode>(HttpStatus.INTERNAL_SERVER_ERROR, "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef\uff01", rescueNode);
            return apiResponse;
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new ApiResponse<RescueNode>(HttpStatus.OK, "\u64cd\u4f5c\u6210\u529f\uff01", rescueNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse<RescueNodeFile> addFile(RescueNodeFile rescueNodeFile) {
        if (ObjectUtils.isEmpty((Object)rescueNodeFile)) {
            return new ApiResponse<RescueNodeFile>(HttpStatus.INTERNAL_SERVER_ERROR, "\u6570\u636e\u5f02\u5e38\uff01", rescueNodeFile);
        }
        BizDataReceive dataReceive = new BizDataReceive();
        dataReceive.setContent(JSONObject.toJSONString((Object)rescueNodeFile));
        dataReceive.setSourceSystem("\u9633\u5149\u6551\u63f4");
        dataReceive.setBusinessType("\u6551\u63f4\u56fe\u7247\u4fe1\u606f");
        dataReceive.setReceiveTime(LocalDateTime.now());
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            String rescueNode = RescueNodeEnum.getXcCodeByName(String.valueOf(rescueNodeFile.getProcessId()));
            queryWrapper.eq(BizRescueHandle::getRescueNode, (Object)rescueNode);
            queryWrapper.eq(BizRescueHandle::getRescueId, (Object)rescueNodeFile.getOrderId());
            BizRescueHandle bizRescueHandle = (BizRescueHandle)((Object)this.bizRescueHandleManager.getOne((Wrapper)queryWrapper));
            if (Objects.isNull((Object)bizRescueHandle)) {
                throw new BaseException("\u53c2\u6570\u9519\u8bef\uff0c\u6839\u636e\u6551\u63f4\u5de5\u5355ID\u65e0\u6cd5\u83b7\u53d6\u6551\u63f4\u5355\u4fe1\u606f\uff01");
            }
            ArrayList<MultipartFile> files = new ArrayList<MultipartFile>();
            MultipartFile multipartFile = ReceiveRescueManagerImpl.base64ToMultipart(rescueNodeFile.getFileData(), rescueNodeFile.getFileName());
            files.add(multipartFile);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("storeType", (Object)"minio");
            DefaultFile file = (DefaultFile)JsonUtil.toBean((String)jsonObject.toString(), DefaultFile.class);
            UploadResult uploadResult = this.fileManager.uploadFile(file, files, null, null, null);
            this.fileManager.updateFileBizIdByIds(Collections.singletonList(uploadResult.getFileId()), bizRescueHandle.getId());
            dataReceive.setProcessStatus(1);
        }
        catch (Exception e) {
            dataReceive.setProcessStatus(2);
            dataReceive.setErrorMessage(e.getMessage());
            log.error("\u63a5\u6536\u9633\u5149\u6551\u63f4\u8282\u70b9\u6587\u4ef6\u5904\u7406\u5931\u8d25\uff01\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            ApiResponse<RescueNodeFile> apiResponse = new ApiResponse<RescueNodeFile>(HttpStatus.INTERNAL_SERVER_ERROR, "\u5185\u90e8\u670d\u52a1\u5668\u9519\u8bef\uff01", rescueNodeFile);
            return apiResponse;
        }
        finally {
            this.bizDataReceiveManager.saveOrUpdate((Object)dataReceive);
        }
        return new ApiResponse<RescueNodeFile>(HttpStatus.OK, "\u64cd\u4f5c\u6210\u529f\uff01", rescueNodeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultipartFile base64ToMultipart(String base64, String fileName) {
        String[] parts = base64.split(",");
        String data = parts.length == 2 ? parts[1] : base64;
        byte[] fileBytes = Base64.getDecoder().decode(data);
        File tempFile = null;
        try {
            tempFile = File.createTempFile("upload_", fileName);
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                fos.write(fileBytes);
            }
            DiskFileItem fileItem = new DiskFileItem("file", "application/octet-stream", false, fileName, fileBytes.length, tempFile.getParentFile());
            try (InputStream input = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);
                 OutputStream os = fileItem.getOutputStream();){
                int n;
                byte[] buffer = new byte[8192];
                while ((n = input.read(buffer)) != -1) {
                    os.write(buffer, 0, n);
                }
            }
            var7_8 = new CommonsMultipartFile((FileItem)fileItem);
            return var7_8;
        }
        catch (Exception e) {
            log.error("Base64\u8f6cMultipart\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return null;
    }

    public static String getPegVal(String stake) {
        if (stake == null) {
            return null;
        }
        int kIndex = stake.indexOf("K");
        if (kIndex == -1) {
            return "";
        }
        String result = stake.substring(kIndex);
        int mIndex = result.indexOf("M");
        if (mIndex != -1) {
            result = result.substring(0, mIndex);
        }
        return result;
    }
}

