/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.open.aop;

import com.artfess.base.util.StringUtil;
import com.artfess.rescue.open.aop.AutoSetNowTime;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoSetNowTimeAspect {
    private static final Logger log = LoggerFactory.getLogger(AutoSetNowTimeAspect.class);

    @Around(value="execution(* com.artfess..*(..))")
    public Object processAutoSetNowTime(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        LocalDate now = LocalDate.now();
        for (Object arg : args) {
            if (arg == null || !arg.getClass().isAnnotationPresent(AutoSetNowTime.class)) continue;
            try {
                Field[] fields;
                LocalDate referenceDate;
                String type = this.getFieldValue(arg, "type", String.class);
                LocalDate month = this.getFieldValue(arg, "month", LocalDate.class);
                LocalDate localDate = referenceDate = month != null ? month : now;
                if (StringUtil.isNotEmpty((String)type) && type.equals("day")) {
                    referenceDate = now;
                }
                for (Field field : fields = arg.getClass().getDeclaredFields()) {
                    if (!"startTime".equals(field.getName()) && !"endTime".equals(field.getName())) continue;
                    field.setAccessible(true);
                    if (field.get(arg) != null) continue;
                    LocalDateTime defaultValue = this.calculateDefaultValue(field.getName(), type, referenceDate);
                    field.set(arg, defaultValue);
                }
            }
            catch (Exception e) {
                log.error("\u5904\u7406AutoSetNowTime\u65f6\u51fa\u9519: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return joinPoint.proceed(args);
    }

    private <T> T getFieldValue(Object obj, String fieldName, Class<T> clazz) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return clazz.cast(field.get(obj));
        }
        catch (Exception e) {
            return null;
        }
    }

    private LocalDateTime calculateDefaultValue(String fieldName, String type, LocalDate referenceDate) {
        if (StringUtil.isNotEmpty((String)type) && !type.equals("day")) {
            if (type.equals("year")) {
                int year = referenceDate.getYear();
                return "startTime".equals(fieldName) ? LocalDate.of(year, 1, 1).atStartOfDay() : LocalDate.of(year, 12, 31).atTime(23, 59, 59);
            }
            if (type.equals("month")) {
                YearMonth yearMonth = YearMonth.from(referenceDate);
                return "startTime".equals(fieldName) ? yearMonth.atDay(1).atStartOfDay() : yearMonth.atEndOfMonth().atTime(23, 59, 59);
            }
        } else {
            return "startTime".equals(fieldName) ? LocalDate.now().atStartOfDay() : LocalDate.now().atTime(23, 59, 59);
        }
        return null;
    }
}

