package com.artfess.form.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.form.dao.FormRemindDataDao;
import com.artfess.form.manager.FormRemindDataManager;
import com.artfess.form.model.FormRemindData;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IUserGroupService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 提醒业务对象 服务实现类
 *
 * @author chens
 * @company 阿特菲斯信息技术有限公司
 * @since 2020-07-07
 */
@Service
public class FormRemindDataManagerImpl extends BaseManagerImpl<FormRemindDataDao, FormRemindData> implements FormRemindDataManager {

    @Resource
    IUserGroupService defaultUserGroupService;

    @Override
    public void deleteFormRemindDataByBoDataId(QueryWrapper queryWrapper) throws IOException {
//        baseMapper.delete(Wrappers.<FormRemindData>lambdaQuery().eq(FormRemindData::getOpemId,boDataId));
        baseMapper.delete(queryWrapper);
    }

    @Override
    public List<FormRemindData> getFormRemindDataByUser() {
        Map<String, String> map = this.convertGroupList(ContextUtil.getCurrentUserId());
        List<FormRemindData> formRemindDataByUser = baseMapper.getFormRemindDataByUser(map);
        return formRemindDataByUser;
    }

    private Map<String, String> convertGroupList(String userId) {
        List<IGroup> list = defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        Map<String, String> map = new HashMap<String, String>();
        map.put("user", userId);
        if (BeanUtils.isEmpty(list))
            return map;
        for (IGroup group : list) {
            String type = group.getGroupType();
            if (map.containsKey(type)) {
                String groupId = map.get(type);
                groupId += ",'" + group.getGroupId() + "'";
                map.put(type, groupId);
            } else {
                map.put(type, "'" + group.getGroupId() + "'");
            }
        }
        return map;
    }
}
