package com.artfess.sysConfig.persistence.manager;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.artfess.base.manager.BaseManager;
import com.artfess.sysConfig.persistence.model.SysAuthUser;

/**
 * 对象功能:流程定义权限明细 Manager类
 * 开发公司:广州宏天软件有限公司
 * 开发人员:xucx
 * 创建时间:2014-03-05 14:10:50
 */
public interface SysAuthUserManager extends  BaseManager<SysAuthUser>{
	/**
	 * 获取首页栏目权限
	 * @param id
	 * @param objType
	 * @return
	 * @throws IOException 
	 */
	public ArrayNode getRights(String id,String objType) throws IOException;
	/**
	 * 保存首页栏目/应用中心应用权限
	 * @param id
	 * @param objType
	 * @param ownerNameJson
	 * @throws IOException 
	 */
	public void saveRights(String id,String objType,String ownerNameJson) throws IOException;

	/**
	 * 批量保存权限
	 * @param ids
	 * @param objType
	 * @param ownerNameJson
	 * @throws IOException
	 */
	public void batchSaveRights(List<String> ids,String objType, String ownerNameJson) throws IOException;
	/**
	 * 通过objType获取当前用户权限
	 * @param objType
	 * @return
	 */
	public List<String> getAuthorizeIdsByUserMap(String objType);
	/**
	 * 判断用户对某个模块数据是否有权限
	 * @param userID
	 * @param authorizeId
	 */
	public boolean hasRights(String authorizeId);
	/**
	 * 删除指定用户的权限缓存
	 * @param userId
	 */
	void delUserMenuCache(String userId);

	boolean getAuthorizeAppMenuId(String menuId, Map<String,String> userRightMap);

    List<String> filterAuth(List<String> ids);

	/**
	 * 新建默认权限为任何人
	 * @param authorizeId
	 */
	void createDefault(String authorizeId);

	/**
	 * 获取授权的items
	 * @param items
	 * @param function
	 * @param <T>
	 * @return
	 */
	<T> List<T> getAuthItems(List<T> items, Function<T,String> function);
}
