package com.artfess.uc.service.impl;

import com.artfess.base.service.SecurityMachinePersonService;
import com.artfess.security.dao.SecurityMachineDao;
import com.artfess.security.dao.SecurityPersonloginlimitDao;
import com.artfess.security.model.SecurityMachine;
import com.artfess.security.model.SecurityPersonloginlimit;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Primary
@Service
public class SecurityMachinePersonServiceImpl implements SecurityMachinePersonService {
	@Resource
	SecurityPersonloginlimitDao personloginlimitDao;
	@Resource
	SecurityMachineDao machineDao;

	@Override
	public List<String> queryPersonLimitByAccount(String account) {
		Assert.hasText(account, "人员账号不能为空！");
		QueryWrapper<SecurityPersonloginlimit> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("ACCOUNT_", account);
		List<SecurityPersonloginlimit> list = personloginlimitDao.selectList(queryWrapper);
		if(list!=null && list.size()>0){
			List<String> machineIdsList = new ArrayList<>();
			for(SecurityPersonloginlimit personloginlimit : list){
				machineIdsList.add(personloginlimit.getMachineId());
			}
			return machineIdsList;
		}else{
			return null;
		}
	}

	@Override
	public List<String> queryMachineIps(List<String> machineIdList) {
		Assert.notEmpty(machineIdList, "涉密计算机ID不能为空！");
		List<SecurityMachine> list = machineDao.selectBatchIds(machineIdList);
		if(list!=null && list.size()>0){
			List<String> machineIpList = new ArrayList<>();
			for(SecurityMachine securityMachine :list){
				machineIpList.add(securityMachine.getIp());
			}
			return machineIpList;
		}else{
			return null;
		}
	}
}
