package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.dao.ShiftUserDao;
import com.artfess.uc.manager.ShiftUserManager;
import com.artfess.uc.model.ShiftUser;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 *
 * <pre>
 * 描述：排班用户 处理实现类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-08-05 14:22:59
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@Service("shiftUserManager")
public class ShiftUserManagerImpl extends BaseManagerImpl<ShiftUserDao, ShiftUser> implements ShiftUserManager{

    @Override
    public void saveShiftUser(List<ShiftUser> shiftUser) {
        shiftUser.forEach(item -> {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq("user_id_",item.getUserId());
            ShiftUser user = baseMapper.selectOne(wrapper);
            if (BeanUtils.isEmpty(user)){
                create(item);
            }else {
                user.setShiftId(item.getShiftId());
                update(user);
            }
        });
    }

    @Override
    public void removeByUserIds(String... ids) {
        for (String id: ids){
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq("user_id_",id);
            baseMapper.delete(wrapper);
        }
    }
}
