package com.artfess.uc.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.service.PwdStrategyService;
import com.artfess.base.util.JsonUtil;
import com.artfess.uc.dao.PwdStrategyDao;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.model.PwdStrategy;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.stereotype.Service;

@Service("pwdStrategyManager")
public class PwdStrategyManagerImpl extends BaseManagerImpl<PwdStrategyDao, PwdStrategy> implements PwdStrategyManager,PwdStrategyService{

	@Override
	public PwdStrategy getDefault() {
		return baseMapper.getDefault();
	}

	@Override
	public JsonNode getJsonDefault() {
		try {
			PwdStrategy pwdStrategy = baseMapper.getDefault();
			return JsonUtil.toJsonNode(pwdStrategy);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BaseException("获取默认密码策略失败",e);
		}
	}

}
