package com.artfess.examine.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: wsf
 * @Description: 年度课目成绩VO
 * @DateTime: 2025/1/16 16:10
 **/
@Data
public class YearSubjectScoreVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "试卷ID")
    private String paperId;

    @ApiModelProperty(value = "用户ID")
    private String userId;

    @ApiModelProperty(value = "用户名")
    private String userName;

    @ApiModelProperty(value = "科目名称")
    private String subjectName;

    @ApiModelProperty(value = "科目类型【字典】（1：基础共同训练，2：专业共同，3：岗前训练-已禁用，4：专业训练）")
    private String trainType;

    @ApiModelProperty(value = "成绩")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    private BigDecimal score;

    @ApiModelProperty(value = "评定级别【字典】（1：优秀，2：良好，3：及格，4：不及格）")
    private String level;
}
