package com.artfess.examine.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 科目分类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Data
@ApiModel(value="ExamSubjectType对象", description="科目分类")
public class ExamSubjectType extends BaseTreeModel<ExamSubjectType> implements Tree {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "层级类型")
    private String type;

    @ApiModelProperty(value = "装备id")
    private String sysId;

    @ApiModelProperty(value = "组织id")
    private String orgId;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    @TableField(exist = false)
    private String trainType;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<ExamSubjectType> children = Lists.newArrayList();

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
