package com.artfess.data.model;

import java.math.BigDecimal;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;

import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 训练总计划
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-12-04
 */
@Data
@ApiModel(value="BizExamGeneralPlan对象", description="训练总计划")
public class BizExamGeneralPlan extends AutoFillModel<BizExamGeneralPlan> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "年度")
    @TableField("year_")
    private String year;

    @NotNull(message = "请选择计划类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计划类型【字典】(1:年度、2:阶段、3:月、4:周、5:排班、6:集约、7补训)")
    @TableField("plan_type_")
    private String planType;

    @ApiModelProperty(value = "季度")
    @TableField("quarter_")
    private String quarter;

    @ApiModelProperty(value = "月份")
    @TableField("month_")
    private Integer month;

    @ApiModelProperty(value = "周序号【字典】（1：第一周、2：第二周、3：第三周、4：第四周）")
    @TableField("week_")
    private String week;

    @NotNull(message = "请填写开始时间", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "开始时间")
    @TableField("start_time_")
    private LocalDate startTime;

    @NotNull(message = "请填写结束时间", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "结束时间")
    @TableField("end_time_")
    private LocalDate endTime;

    @ApiModelProperty(value = "训练时长(h)")
    @TableField("hour_")
    private BigDecimal hour;

    @ApiModelProperty(value = "计划状态(0:待确认、1:执行中、2:已完成、3:未完成)")
    @TableField("plan_status_")
    private String planStatus;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "单位训练计划")
    @TableField(exist = false)
    private List<BizExamPlanSubject> planList;

    @ApiModelProperty(value = "单位id")
    @TableField(exist = false)
    private String orgId;

    @ApiModelProperty(value = "单位")
    @TableField(exist = false)
    private String orgName;

    @ApiModelProperty(value = "专业id")
    @TableField(exist = false)
    private String majorId;

    @ApiModelProperty(value = "专业")
    @TableField(exist = false)
    private String majorName;

    @Excel(name = "岗位", column = "D")
    @ApiModelProperty(value = "岗位")
    @TableField(exist = false)
    private String post;

    @ApiModelProperty(value = "岗位ID")
    @TableField(exist = false)
    private String postId;

    @ApiModelProperty(value = "训练课目")
    @TableField(exist = false)
    private String subjectName;

    @ApiModelProperty(value = "训练课目id")
    @TableField(exist = false)
    private String subjectId;

    @Excel(name = "训练等级", column = "E")
    @ApiModelProperty(value = "训练等级")
    @TableField(exist = false)
    private String trainLevel;

    @ApiModelProperty(value = "应训人数（人）")
    @TableField(exist = false)
    private Long totalNum;

    @ApiModelProperty(value = "已训人数（人）")
    @TableField(exist = false)
    private Long realityNum;

    @ApiModelProperty(value = "训练场地id")
    @TableField(exist = false)
    private String spaceId;

    @ApiModelProperty(value = "训练场地")
    @TableField(exist = false)
    private String spaceName;

    @ApiModelProperty(value = "教练员ID")
    @TableField(exist = false)
    private String coachId;

    @ApiModelProperty(value = "教练员")
    @TableField(exist = false)
    private String coachName;

    @ApiModelProperty(value = "主训员id")
    @TableField(exist = false)
    private String mainUserId;

    @ApiModelProperty(value = "主训员")
    @TableField(exist = false)
    private String mainUserName;

    @ApiModelProperty(value = "训练方式【字典】（1：集中组织、2：自行学习）")
    @TableField(exist = false)
    private String way;

    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    @TableField(exist = false)
    private String trainType;

    @ApiModelProperty(value = "训练内容及要求")
    @TableField(exist = false)
    private String trainContent;

}
