package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizTrainQuestionDataDao;
import com.artfess.data.manager.BizTrainQuestionDataManager;
import com.artfess.data.model.BizTrainQuestionData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 训练问题数据 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Service
public class BizTrainQuestionDataManagerImpl extends BaseManagerImpl<BizTrainQuestionDataDao, BizTrainQuestionData> implements BizTrainQuestionDataManager {

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveList(List<BizTrainQuestionData> list) {
        QueryWrapper<ExamSubjectInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        List<ExamSubjectInfo> subjectInfos = subjectInfoManager.list(queryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(baseData -> {
            Assert.hasText(baseData.getOrgName(), "请填写训练单位");
            Assert.hasText(baseData.getSubjectName(), "请填写训练课目");
            Assert.hasText(baseData.getYear(), "请填写训练年度");
            if(CollectionUtils.isEmpty(subjectInfoMap)) {
                return;
            }
            if(!CollectionUtils.isEmpty(subjectInfoMap) && null != subjectInfoMap.get(baseData.getSubjectName())) {
                baseData.setSubjectId(subjectInfoMap.get(baseData.getSubjectName()).getId());
            }

            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(baseData.getOrgName())) {
                baseData.setOrgId(orgMap.get(baseData.getOrgName()).getId());
            }
        });
        this.saveBatch(list);
    }
}
