/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizControlDataDao;
import com.artfess.data.manager.BizControlDataManager;
import com.artfess.data.model.BizControlData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizControlDataManagerImpl
extends BaseManagerImpl<BizControlDataDao, BizControlData>
implements BizControlDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;

    @Override
    @Transactional
    public void saveList(List<BizControlData> list) {
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(data -> {
            Assert.hasText((String)data.getOrgName(), (String)"\u8bf7\u586b\u5199\u5355\u4f4d");
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(data.getOrgName())) {
                data.setOrgId(((OrgVo)((Object)((Object)orgMap.get(data.getOrgName())))).getId());
            }
        });
        this.saveBatch(list);
    }
}

