package com.artfess.application.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 业务提醒配置
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-12-21
 */
@Data
@TableName("portal_sys_remind_config")
@ApiModel(value="PortalSysRemindConfig对象", description="业务提醒配置")
public class RemindConfig extends AutoFillModel<RemindConfig> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写提醒名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "提醒名称（定时任务的任务名称）")
    @TableField("name_")
    private String name;

    @NotBlank(message = "请填写提醒配置编码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "提醒配置编码(唯一)（定时任务的任务编码）")
    @TableField("code_")
    private String code;

    @NotBlank(message = "请选择消息配置", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "消息配置id")
    @TableField("msg_id_")
    private String msgId;

    @ApiModelProperty(value = "业务规则类名称）", hidden = true)
    @TableField("biz_class_")
    private String bizClass;

    @NotBlank(message = "请选择工作提醒类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "工作提醒类型（字典")
    @TableField("plan_class_")
    private String planClass;

    @NotNull(message = "请选择计划类型", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计划类型(1:启动一次  2:每分钟执行  3:每天时间点执行  4:每周时间点执行  5:每月执行  6:cron表达式)")
    @TableField("plan_type_")
    private Integer planType;

    @ApiModelProperty(value = "计划执行的表达式")
    @TableField("plan_interval_")
    private String planInterval;

    @ApiModelProperty(value = "提醒描述")
    @TableField("description_")
    private String description;

    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "任务运行状态( NONE：停止, NORMAL：运行,PAUSED：暂停)")
    @TableField(exist = false)
    private String taskStatus;

    @ApiModelProperty(name="tplKey", notes="短信模板编号")
    @TableField(exist = false)
    protected String tplKey;

    @ApiModelProperty(name="notifyType", notes="消息提醒方式(voice: '语音', mail: '邮件', sms: '短信', inner: '站内消息')，多个用“,”号隔开")
    @TableField(exist = false)
    protected String notifyType;

    @ApiModelProperty(name="userConfigType", notes="接收人配置方式(1:动态，2：固定)", hidden = true)
    @TableField(exist = false)
    protected Short userConfigType = 2;

    @ApiModelProperty(name="userStr", notes="接收人配置信息（动态配置：el表达式；固定方式：json格式字符串）")
    @TableField(exist = false)
    protected String userStr;

}
