/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.colmap;

import com.artfess.table.meta.impl.MySQLTableMeta;
import com.artfess.table.model.Column;
import com.artfess.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class MySQLColumnMap
implements RowMapper<Column> {
    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("column_name");
        String is_nullable = rs.getString("is_nullable");
        String data_type = rs.getString("data_type");
        String length = rs.getString("length");
        String precisions = rs.getString("precisions");
        String scale = rs.getString("scale");
        String column_key = rs.getString("column_key");
        String column_comment = rs.getString("column_comment");
        String table_name = rs.getString("table_name");
        String column_type = rs.getString("column_type");
        column_comment = MySQLTableMeta.getComments(column_comment, name);
        int iLength = 0;
        try {
            iLength = StringUtils.isEmpty((String)length) ? 0 : Integer.parseInt(length);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int iPrecisions = StringUtils.isEmpty((String)precisions) ? 0 : Integer.parseInt(precisions);
        int iScale = StringUtils.isEmpty((String)scale) ? 0 : Integer.parseInt(scale);
        column.setFieldName(name);
        column.setTableName(table_name);
        column.setComment(column_comment);
        column.setFcolumnType(column_type);
        if (StringUtils.isNotEmpty((String)column_key) && "PRI".equals(column_key)) {
            column.setIsPk(true);
        }
        boolean isNull = is_nullable.equals("YES");
        column.setIsNull(isNull);
        this.setType(data_type, iLength, iPrecisions, iScale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column columnModel) {
        if (dbtype.equals("bigint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(19);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("int")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(10);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("mediumint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(7);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("smallint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(5);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("tinyint")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(3);
            columnModel.setDecimalLen(0);
            return;
        }
        if (dbtype.equals("decimal")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(precision - scale);
            columnModel.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("double")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(18);
            columnModel.setDecimalLen(4);
            return;
        }
        if (dbtype.equals("float")) {
            columnModel.setColumnType("number");
            columnModel.setIntLen(8);
            columnModel.setDecimalLen(4);
            return;
        }
        if (dbtype.equals("varchar")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.equals("char") || dbtype.equals("bit")) {
            columnModel.setColumnType("varchar");
            columnModel.setCharLen(length);
            return;
        }
        if (dbtype.startsWith("date")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.startsWith("time")) {
            columnModel.setColumnType("date");
            return;
        }
        if (dbtype.endsWith("text")) {
            columnModel.setColumnType("clob");
            columnModel.setCharLen(65535);
            return;
        }
        if (dbtype.endsWith("blob")) {
            columnModel.setColumnType("clob");
            columnModel.setCharLen(65535);
            return;
        }
        if (dbtype.endsWith("clob")) {
            columnModel.setColumnType("clob");
            columnModel.setCharLen(65535);
            return;
        }
    }
}

