/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.sysConfig.persistence.dao.SysTypeDao;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysTypeManager")
public class SysTypeManagerImpl
extends BaseManagerImpl<SysTypeDao, SysType>
implements SysTypeManager {
    @Resource
    DataDictManager dataDictManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    JmsProducer jmsProducer;

    @Override
    public List<SysType> getByParentId(String parentId) {
        return ((SysTypeDao)this.baseMapper).getByParentId(parentId);
    }

    @Override
    public SysType getInitSysType(int isRoot, String parentId) {
        SysType sysType = new SysType();
        String typeId = UniqueIdUtil.getSuid();
        if (isRoot == 1) {
            SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)parentId));
            sysType.setTypeKey(sysCategory.getGroupKey());
            sysType.setTypeGroupKey(sysCategory.getGroupKey());
            sysType.setParentId(parentId);
            sysType.setStruType(sysCategory.getType());
            sysType.setPath(parentId + "." + typeId + ".");
            sysType.setName(sysCategory.getName());
        } else {
            sysType = (SysType)this.get((Serializable)((Object)parentId));
            String path = sysType.getPath();
            sysType.setPath(path + typeId + ".");
        }
        sysType.setId(typeId);
        return sysType;
    }

    @Override
    public SysType getInitSysTypeOldId(int isRoot, String parentId, String typeId) {
        SysType sysType = new SysType();
        if (isRoot == 1) {
            SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)parentId));
            sysType.setTypeKey(sysCategory.getGroupKey());
            sysType.setTypeGroupKey(sysCategory.getGroupKey());
            sysType.setParentId(parentId);
            sysType.setStruType(sysCategory.getType());
            sysType.setPath(parentId + "." + typeId + ".");
            sysType.setName(sysCategory.getName());
        } else {
            sysType = (SysType)this.get((Serializable)((Object)parentId));
            String path = sysType.getPath();
            sysType.setPath(path + typeId + ".");
        }
        sysType.setId(typeId);
        return sysType;
    }

    @Override
    public boolean isKeyExist(String id, String typeGroupKey, String typeKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typeKey", typeKey);
        params.put("typeGroupKey", typeGroupKey);
        params.put("id", id);
        return ((SysTypeDao)this.baseMapper).isKeyExist(params) > 0;
    }

    @Override
    public List<SysType> getByGroupKey(String groupKey) {
        return ((SysTypeDao)this.baseMapper).getByGroupKey(groupKey);
    }

    @Override
    public void delByIds(String id) {
        if (BeanUtils.isEmpty((Object)id)) {
            return;
        }
        SysType sysType = (SysType)this.get((Serializable)((Object)id));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        List<SysType> sysTypes = ((SysTypeDao)this.baseMapper).getByPath(params);
        this.remove((Serializable)((Object)id));
        this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(sysType.getTypeGroupKey(), sysType.getId(), sysType.getName(), sysType.getName(), Integer.valueOf(2)));
        for (SysType sType : sysTypes) {
            String Id = sType.getId();
            this.remove((Serializable)((Object)Id));
            this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(sType.getTypeGroupKey(), sType.getId(), sType.getName(), sType.getName(), Integer.valueOf(2)));
        }
    }

    @Override
    public List<SysType> getPrivByPartId(String parentId, String userId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentId", parentId);
        params.put("userId", userId);
        return ((SysTypeDao)this.baseMapper).getPrivByPartId(params);
    }

    @Override
    public void updSn(String typeId, int sn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId);
        params.put("sn", sn);
        ((SysTypeDao)this.baseMapper).updSn(params);
    }

    @Override
    public List<SysType> getChildByTypeKey(String typeKey) {
        SysType sysType = ((SysTypeDao)this.baseMapper).getByTypeKey(typeKey);
        if (sysType == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        return ((SysTypeDao)this.baseMapper).getByPath(params);
    }

    @Override
    public SysType getByKey(String typeKey) {
        return ((SysTypeDao)this.baseMapper).getByTypeKey(typeKey);
    }

    @Override
    public String getXmlByKey(String groupKey) {
        List<SysType> sysTypes = this.getByGroupKey(groupKey);
        StringBuffer sb = new StringBuffer("<folder id='0' label='\u5168\u90e8'>");
        sb.append("</folder>");
        return sb.toString();
    }

    private void contructXml(List<SysType> sysTypes, String parentId, StringBuffer sb) {
        if (BeanUtils.isEmpty(sysTypes)) {
            return;
        }
        for (SysType type : sysTypes) {
            if (!parentId.equals(type.getParentId())) continue;
            sb.append("<folder id='" + type.getId() + "' label='" + type.getName() + "'>");
            this.contructXml(sysTypes, type.getId(), sb);
            sb.append("</folder>");
        }
    }

    @Override
    public SysType getByTypeKeyAndGroupKey(String groupKey, String typeKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupKey", groupKey);
        params.put("typeKey", typeKey);
        return ((SysTypeDao)this.baseMapper).getByTypeKeyAndGroupKey(params);
    }

    @Override
    @Transactional
    public List<SysType> getChildByTypeId(String typeId) {
        SysType sysType = (SysType)((Object)((SysTypeDao)this.baseMapper).selectById((Serializable)((Object)typeId)));
        if (sysType == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", sysType.getPath());
        return ((SysTypeDao)this.baseMapper).getByPath(params);
    }
}

