/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.attachmentService;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;
import com.artfess.file.util.AppFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.stereotype.Service;

@Service
public class FolderAttachmentServiceImpl
implements AttachmentService {
    public void remove(Attachment attachment, String propertiesId) throws Exception {
        String attachPath = this.getAttachPath(propertiesId, attachment);
        String filePath = attachment.getFilePath();
        if (!attachment.getEntryptName().booleanValue()) {
            filePath = filePath.replace(attachment.getId(), attachment.getFileName());
        }
        String fullPath = attachPath + File.separator + filePath;
        FileUtil.deleteFile((String)fullPath);
    }

    public void upload(Attachment attachment, InputStream inputStream, String propertiesId) throws Exception {
        String filePath = attachment.getFilePath();
        String attachPath = this.getAttachPath(propertiesId, attachment);
        if (!attachment.getEntryptName().booleanValue()) {
            filePath = filePath.replace(attachment.getId(), attachment.getFileName());
        }
        filePath = attachPath + File.separator + filePath;
        if (BeanUtils.isNotEmpty((Object)inputStream)) {
            FileUtil.createFolderFile((String)filePath);
            FileUtil.writeFile((String)filePath, (InputStream)inputStream);
        } else {
            FileUtil.writeByte((String)filePath, (byte[])attachment.getBytes());
        }
    }

    public void download(Attachment attachment, OutputStream outStream, String propertiesId) throws Exception {
        String fullPath;
        File file;
        String filePath = attachment.getFilePath();
        String attachPath = this.getAttachPath(propertiesId, attachment);
        if (!attachment.getEntryptName().booleanValue()) {
            filePath = filePath.replace(attachment.getId(), attachment.getFileName());
        }
        if ((file = new File(fullPath = (filePath = attachPath + File.separator + filePath).replace("/", File.separator))).exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(fullPath);
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = inputStream.read(b)) > 0) {
                    outStream.write(b, 0, i);
                }
                outStream.flush();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
        } else {
            throw new RuntimeException("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public String getStoreType() {
        return "folder";
    }

    public boolean chekckFile(Attachment attachment, String propertiesId) {
        String filePath = attachment.getFilePath();
        String attachPath = this.getAttachPath(propertiesId, attachment);
        if (!attachment.getEntryptName().booleanValue()) {
            filePath = filePath.replace(attachment.getId(), attachment.getFileName());
        }
        filePath = attachPath + File.separator + filePath;
        String fullPath = filePath.replace("/", File.separator);
        File file = new File(fullPath);
        return file.exists();
    }

    private String getAttachPath(String propertiesId, Attachment attachment) {
        FlowUploadPropertiesStorageDTO uploadProperties = this.getUploadProperties(propertiesId);
        String attachPath = "";
        if (BeanUtils.isNotEmpty((Object)uploadProperties)) {
            attachPath = uploadProperties.getLocation();
            attachment.setEntryptName(Boolean.valueOf(uploadProperties.getEncryptName() != 0));
        } else {
            attachPath = AppFileUtil.getAttachPath();
        }
        return attachPath;
    }

    private FlowUploadPropertiesStorageDTO getUploadProperties(String propertiesId) {
        if (StringUtil.isEmpty((String)propertiesId)) {
            return null;
        }
        FlowUploadPropertiesManager uploadPropertiesManager = (FlowUploadPropertiesManager)AppUtil.getBean(FlowUploadPropertiesManager.class);
        return uploadPropertiesManager.getById(propertiesId);
    }

    public byte[] getFileBytes(Attachment sysFile) throws Exception {
        String filePath = sysFile.getFilePath();
        String fullPath = StringUtil.trimSufffix((String)AppFileUtil.getAttachPath(), (String)File.separator) + File.separator + filePath.replace("/", File.separator);
        File file = new File(fullPath);
        if (file.exists()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(fullPath);
                byte[] b = new byte[1024];
                int i = 0;
                while ((i = inputStream.read(b)) > 0) {
                    outStream.write(b, 0, i);
                }
                outStream.flush();
                byte[] byArray = outStream.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
                if (outStream != null) {
                    outStream.close();
                    outStream = null;
                }
            }
        }
        throw new RuntimeException("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728");
    }

    public String getUrl(Attachment attachment) {
        return null;
    }

    public String initMultiPartUpload(Attachment attachment) {
        return null;
    }

    public String getChunkUrl(Attachment attachment, Integer partNumber, String uploadId) {
        return null;
    }

    public boolean mergeMultipartUpload(Attachment attachment, String uploadId, int realyPartNumber) {
        return false;
    }
}

