/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.listener;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.ProcessInstCmd;
import com.artfess.bpm.api.constant.AopType;
import com.artfess.bpm.api.event.BpmStartEvent;
import com.artfess.bpm.api.event.BpmStartModel;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.listener.BusDataUtil;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BpmStartEventListener
implements ApplicationListener<BpmStartEvent>,
Ordered {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource(name="defaultBpmFormService")
    BpmFormService bpmFormService;

    public void onApplicationEvent(BpmStartEvent ev) {
        BpmStartModel model = (BpmStartModel)ev.getSource();
        this.setBuinessKey(model);
        if (AopType.PREVIOUS.equals((Object)model.getAopType())) {
            try {
                this.before(model);
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.after(model);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    private void setBuinessKey(BpmStartModel model) {
        ActionCmd cmd = model.getCmd();
        if (cmd instanceof ProcessInstCmd) {
            String dataMode = cmd.getDataMode();
            if (!"pk".equals(dataMode)) {
                return;
            }
            DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)model.getBpmProcessInstance();
            String pk = cmd.getBusinessKey();
            String pkInst = inst.getBizKey();
            if (StringUtil.isEmpty((String)pk) && StringUtil.isNotEmpty((String)pkInst)) {
                cmd.setBusinessKey(pkInst);
                cmd.setSysCode(inst.getSysCode());
            }
        }
    }

    private void before(BpmStartModel model) throws Exception {
        this.executeHandler(model, true);
        this.addBusLink(model);
    }

    private NodeProperties getStartProperties(BpmProcessInstance instance) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
        BpmNodeDef bpmNodeDef = bpmProcessDef.getStartEvent();
        NodeProperties properties = bpmNodeDef.getLocalProperties();
        if (properties != null && (StringUtil.isNotEmpty((String)properties.getPrevHandler()) || StringUtil.isNotEmpty((String)properties.getPostHandler()))) {
            return properties;
        }
        List<BpmNodeDef> bpmNodeDefs = bpmProcessDef.getStartNodes();
        for (BpmNodeDef nodeDef : bpmNodeDefs) {
            if (!(nodeDef instanceof UserTaskNodeDef)) continue;
            String parentInstId = instance.getParentInstId();
            if (StringUtil.isZeroEmpty((String)parentInstId)) {
                properties = nodeDef.getLocalProperties();
                break;
            }
            BpmProcessInstance parentInst = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)parentInstId));
            String defKey = parentInst.getProcDefKey();
            properties = nodeDef.getPropertiesByParentDefKey(defKey);
            break;
        }
        return properties;
    }

    private void executeHandler(BpmStartModel model, boolean isBefore) throws Exception {
        BpmProcessInstance instance = model.getBpmProcessInstance();
        ActionCmd cmd = model.getCmd();
        NodeProperties properties = this.getStartProperties(instance);
        BusDataUtil.executeHandler(properties, cmd, isBefore);
    }

    private void addBusLink(BpmStartModel model) throws Exception {
        ActionCmd cmd = model.getCmd();
        if (cmd instanceof ProcessInstCmd) {
            DefaultBpmProcessInstance inst = (DefaultBpmProcessInstance)model.getBpmProcessInstance();
            String dataMode = cmd.getDataMode();
            inst.setDataMode(cmd.getDataMode());
            if (StringUtil.isNotEmpty((String)cmd.getSysCode())) {
                inst.setSysCode(cmd.getSysCode());
            }
            if ("bo".equals(dataMode)) {
                BusDataUtil.handSaveBoData(model.getBpmProcessInstance(), cmd);
            } else if ("pair".equals(dataMode)) {
                BusDataUtil.handExt(cmd);
            } else if ("pk".equals(dataMode)) {
                String pk = cmd.getBusinessKey();
                String pkInst = inst.getBizKey();
                if (StringUtil.isNotEmpty((String)pk) && StringUtil.isEmpty((String)pkInst)) {
                    inst.setBizKey(pk);
                }
            }
        }
    }

    private void after(BpmStartModel model) throws Exception {
        this.executeHandler(model, false);
        this.handleInstForm(model);
    }

    private void handleInstForm(BpmStartModel model) throws Exception {
        BpmProcessInstance instance = model.getBpmProcessInstance();
        this.bpmFormService.handleInstForm(instance.getId(), instance.getProcDefId(), false);
    }

    public int getOrder() {
        return 1;
    }
}

