/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.usercalc.position.runtime;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.artfess.bpm.plugin.usercalc.position.def.PositionPluginDef;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.model.OrgRel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.service.IOrgService;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PositionPlugin
extends AbstractUserCalcPlugin {
    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        JsonNode node;
        Object rust;
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        PositionPluginDef def = (PositionPluginDef)pluginDef;
        String posCode = "";
        String posName = "";
        String source = def.getSource();
        if (StringUtil.isEmpty((String)source)) {
            return identityList;
        }
        IOrgService orgEngine = pluginSession.getOrgEngine();
        Map<String, Object> vars = pluginSession.getVariables();
        if ("startSuper".equals(source)) {
            String startId = (String)vars.get("startUser");
            rust = orgEngine.getUserService().getSuperiorPost(startId);
            if (BeanUtils.isNotEmpty((Object)rust)) {
                node = (JsonNode)rust;
                posCode = node.get("code").asText();
                posName = node.get("name").asText();
            }
        } else if ("prevSuper".equals(source)) {
            String userId = ContextUtil.getCurrentUser().getUserId();
            rust = orgEngine.getUserService().getSuperiorPost(userId);
            if (BeanUtils.isNotEmpty((Object)rust)) {
                node = (JsonNode)rust;
                posCode = node.get("code").asText();
                posName = node.get("name").asText();
            }
        } else if ("spec".equals(source)) {
            posCode = def.getPosCode();
            posName = def.getPosName();
        }
        if (StringUtil.isEmpty((String)posCode)) {
            return identityList;
        }
        boolean isReqUc = StringUtil.isEmpty((String)((String)vars.get("not_request_uc")));
        IGroup group = null;
        group = isReqUc || ExtractType.EXACT_EXACT_USER.equals((Object)def.getExtract()) ? orgEngine.getUserGroupService().getGroupByIdOrCode(GroupTypeConstant.POSITION.key(), posCode) : this.buildPositionGroup(posCode, posName);
        BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(group);
        identityList.add(bpmIdentity);
        return identityList;
    }

    private IGroup buildPositionGroup(String posCode, String posName) {
        OrgRel pos = new OrgRel();
        pos.setCode(posCode);
        pos.setName(posName);
        return pos;
    }
}

