/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.form;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.def.BpmSubTableRight;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.table.datasource.DataSourceUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class BoSubDataHandlerImpl {
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;

    public List<Map<String, Object>> getSubDataByFk(ObjectNode boEnt, Object fkValue) throws Exception {
        String defId = (String)ContextThreadUtil.getCommuVar("defId", "");
        String nodeId = (String)ContextThreadUtil.getCommuVar("nodeId", "");
        String parentDefKey = (String)ContextThreadUtil.getCommuVar("parentDefKey", "local_");
        BpmSubTableRight bpmSubTableRight = this.getSubTableRight(defId, nodeId, parentDefKey, boEnt);
        String sql = "";
        if (boEnt.get("type").asText().equals("manytomany")) {
            sql = "select A.* from " + boEnt.get("tableName").asText() + " A , form_bo_data_relation B where " + " B.SUB_BO_NAME = '" + boEnt.get("name").asText() + "' AND A." + boEnt.get("pkKey").asText() + "=B.FK_  AND B.PK_=?";
        } else {
            String fk = boEnt.get("fk").asText();
            if (StringUtil.isEmpty((String)fk)) {
                throw new RuntimeException("\u901a\u8fc7\u6dfb\u52a0\u5916\u90e8\u8868\u6784\u5efa\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5fc5\u987b\u6307\u5b9a\u5916\u952e");
            }
            sql = "select * from " + boEnt.get("tableName").asText() + " A  where A." + fk + "=?";
        }
        sql = this.handleRight(bpmSubTableRight, fkValue, sql);
        List list = new ArrayList();
        if (boEnt.get("isExternal").asInt() == 1) {
            try {
                list = DataSourceUtil.getJdbcTempByDsAlias((String)boEnt.get("dsName").asText()).queryForList(sql, new Object[]{fkValue});
            }
            catch (Exception e) {
                throw new RuntimeException("\u64cd\u4f5c\u5916\u90e8\u8868\uff1a" + boEnt.get("dsName").asText() + " \u4e2d\u7684 " + boEnt.get("desc").asText() + " \u51fa\u9519\uff1a" + e.getMessage(), e);
            }
        } else {
            list = this.jdbcTemplate.queryForList(sql, new Object[]{fkValue});
        }
        return list;
    }

    private BpmSubTableRight getSubTableRight(String defId, String nodeId, String parentDefKey, ObjectNode boEnt) throws Exception {
        if (StringUtil.isEmpty((String)nodeId)) {
            return null;
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserTaskNodeDef utnd = (UserTaskNodeDef)nodeDef;
        BpmSubTableRight bpmSubTableRight = null;
        List<BpmSubTableRight> list = utnd.getBpmSubTableRightByParentDefKey(parentDefKey);
        for (BpmSubTableRight bsr : list) {
            if (!bsr.getTableName().equals(boEnt.get("name").asText())) continue;
            bpmSubTableRight = bsr;
            break;
        }
        return bpmSubTableRight;
    }

    private String handleRight(BpmSubTableRight right, Object fkValue, String sql) throws Exception {
        if (right == null) {
            return sql;
        }
        if (right.getRightType().equals("script")) {
            String str = this.groovyScriptEngine.executeString(right.getScript(), new HashMap());
            sql = sql + " and " + str;
        } else if (right.getRightType().equals("curUser")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_id_=" + ContextUtil.getCurrentUserId();
        } else if (right.getRightType().equals("curOrg")) {
            sql = "select a.* from (" + sql + ") a , bpm_bus_link b where a.ID_ = B.businesskey_str_ and  B.start_group_id_=" + ContextUtil.getCurrentGroupId();
        }
        return sql;
    }
}

