/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.manager.UserUniteManager;
import com.artfess.uc.model.UserUnite;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc/userUnite/v1/"})
@Api(tags={"\u7528\u6237\u4e0e\u5916\u90e8\u901a\u8baf\u5f55\u5173\u7cfb"})
@ApiGroup(group={"group_uc"})
public class UserUniteController
extends BaseController<UserUniteManager, UserUnite> {
    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u7684\u7528\u6237\u4fe1\u606f", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7ed1\u5b9a\u7b2c\u4e09\u65b9\u7684\u7528\u6237\u4fe1\u606f")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        try {
            ((UserUniteManager)this.baseService).removeByIds(Arrays.asList(ids));
            return new CommonResult("\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @PostMapping(value={"updateUserUnite"})
    @ApiOperation(value="\u66f4\u65b0", httpMethod="POST", notes="\u66f4\u65b0")
    public CommonResult<String> updateUserUnite(@RequestBody UserUnite userUnite) {
        ((UserUniteManager)this.baseService).updateUserUnite(userUnite);
        return new CommonResult("\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58", httpMethod="POST", notes="\u4fdd\u5b58")
    public CommonResult<String> save(@RequestBody UserUnite userUnite) {
        if (BeanUtils.isNotEmpty((Object)userUnite.getId())) {
            ((UserUniteManager)this.baseService).update((Model)userUnite);
        } else {
            ((UserUniteManager)this.baseService).create((Model)userUnite);
        }
        return new CommonResult("\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"getUserUniteByWxWorkId"})
    @ApiOperation(value="\u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55userid\u83b7\u53d6\u6570\u636e", httpMethod="POST", notes="\u6839\u636e\u4f01\u4e1a\u5fae\u4fe1\u901a\u8baf\u5f55userid\u83b7\u53d6\u6570\u636e")
    public Object getUserUniteByWxWorkId(@RequestParam(value="wxWorkId", required=true) String wxWorkId) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"WX_WORK_ID_", (Object)wxWorkId);
        UserUnite exist = (UserUnite)((Object)((UserUniteManager)this.baseService).getOne((Wrapper)queryWrapper));
        return exist;
    }

    @GetMapping(value={"/getByUserId/{userId}"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u6570\u636e")
    public UserUnite getByUserId(@PathVariable String userId) {
        QueryWrapper queryWrapper = (QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)userId);
        UserUnite exist = (UserUnite)((Object)((UserUniteManager)this.baseService).getOne((Wrapper)queryWrapper));
        return exist;
    }

    @GetMapping(value={"/getDingtalkIdsByUserIds"})
    @ApiOperation(value="\u6839\u636euserIds\u83b7\u53d6\u9489\u9489ids", httpMethod="GET", notes="\u6839\u636euserIds\u83b7\u53d6\u9489\u9489ids")
    public String getDingtalkIdsByUserIds(@RequestParam(value="userIds", required=true) String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List dingtalkIds;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = ((UserUniteManager)this.baseService).list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(dingtalkIds = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getDingtalkId())).map(UserUnite::getDingtalkId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", dingtalkIds);
            }
        }
        return "";
    }

    @GetMapping(value={"/getWxWorkIdsByUserIds"})
    @ApiOperation(value="\u6839\u636euserIds\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1ids", httpMethod="GET", notes="\u6839\u636euserIds\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1ids")
    public String getWxWorkIdsByUserIds(@RequestParam(value="userIds", required=true) String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List wxWorkIds;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = ((UserUniteManager)this.baseService).list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(wxWorkIds = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getWxWorkId())).map(UserUnite::getWxWorkId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", wxWorkIds);
            }
        }
        return "";
    }

    @GetMapping(value={"/getOpenIdsByUserIds"})
    @ApiOperation(value="\u6839\u636euserIds\u83b7\u53d6\u516c\u4f17\u53f7openids", httpMethod="GET", notes="\u6839\u636euserIds\u83b7\u53d6\u516c\u4f17\u53f7openids")
    public String getOpenIdsByUserIds(@RequestParam(value="userIds", required=true) String userIds) {
        if (BeanUtils.isNotEmpty((Object)userIds)) {
            List getOpenId;
            Object[] userIdList = userIds.split(",");
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"USER_ID_", userIdList);
            List list = ((UserUniteManager)this.baseService).list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)list) && BeanUtils.isNotEmpty(getOpenId = list.stream().filter(e -> BeanUtils.isNotEmpty((Object)e.getOpenId())).map(UserUnite::getOpenId).collect(Collectors.toList()))) {
                return String.join((CharSequence)",", getOpenId);
            }
        }
        return "";
    }
}

