package com.artfess.portal.kh.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.util.List;

/**
 * 考核计划信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@ApiModel(value="KhSchemePlan对象", description="考核计划信息")
public class KhSchemePlan extends BizDelModel<KhSchemePlan> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "方案ID")
    @TableField("scheme_id_")
    private String schemeId;

    @NotBlank(message = "请输入计划名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "计划名称")
    @TableField("plan_name_")
    private String planName;

    @ApiModelProperty(value = "考核计划开始时间")
    @TableField("start_date_")
    private LocalDate startDate;

    @ApiModelProperty(value = "考核计划结束时间")
    @TableField("end_date_")
    private LocalDate endDate;

    @NotBlank(message = "请选择考核周期", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "考核周期【字典】（1：周，2：月，3：季度，4：半年，5：年）")
    @TableField("period_")
    private String period;

    @ApiModelProperty(value = "是否评级【字典】（0：否，1：是）")
    @TableField("is_assess_")
    private String isAssess;

    @ApiModelProperty(value = "评级方案ID")
    @TableField("assess_id_")
    private String assessId;

    @ApiModelProperty(value = "考评人ID")
    @TableField("appraiser_id_")
    private String appraiserId;

    @ApiModelProperty(value = "考评人姓名")
    @TableField("appraiser_name_")
    private String appraiserName;

    @ApiModelProperty(value = "是否复核【字典】（0：否，1：是）")
    @TableField("is_review_")
    private String isReview;

    @ApiModelProperty(value = "复核人ID")
    @TableField("review_id_")
    private String reviewId;

    @ApiModelProperty(value = "复核人姓名")
    @TableField("review_name_")
    private String reviewName;

    @ApiModelProperty(value = "计划状态【字典】(edit：编辑中，execute：执行中，stop：暂停， end：结束)")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "租户ID")
    @TableField("tenant_id_")
    private String tenantId;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "考核对象信息")
    @TableField(exist = false)
    private List<KhPlanObject> planObjectList;

    @ApiModelProperty(value = "考核方案信息")
    @TableField(exist = false)
    private KhScheme scheme;

    @ApiModelProperty(value = "评级方案信息")
    @TableField(exist = false)
    private KhAssessScheme assessScheme;

}
