/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.service.InvokeResult;
import com.artfess.base.service.ServiceClient;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.index.IndexTabList;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.persistence.dao.SysIndexColumnDao;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.sysConfig.service.AuthorityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysIndexColumnManager")
public class SysIndexColumnManagerImpl
extends BaseManagerImpl<SysIndexColumnDao, SysIndexColumn>
implements SysIndexColumnManager {
    @Resource
    ServiceClient serviceClient;
    @Resource
    AuthorityManager authorityManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    FormFeignService formFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    MultiTenantHandler multiTenantHandler;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysIndexColumnDao sysIndexColumnDao;
    @Value(value="${system.saas.enable:false}")
    Boolean saasEnable;
    private GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine();

    @Override
    public List<SysIndexColumn> getHashRightColumnList(QueryFilter<SysIndexColumn> filter, Map<String, Object> params, Boolean isParse, short type, IUser user) throws Exception {
        List<SysIndexColumn> list;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            if (this.saasEnable.booleanValue()) {
                filter.addFilter(this.multiTenantHandler.getTenantIdColumn(), Arrays.asList("-1", user.getTenantId()), QueryOP.IN);
            }
            list = this.getByUserIdFilter(type, "-1", user.getTenantId());
        }
        if (isParse.booleanValue()) {
            this.parseList(list, params);
        }
        return list;
    }

    private void parseList(List<SysIndexColumn> list, Map<String, Object> params) throws Exception {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (SysIndexColumn sysIndexColumn : list) {
            String templateHtml = this.parseTemplateHtml(sysIndexColumn, params);
            sysIndexColumn.setTemplateHtml(templateHtml);
        }
    }

    public List<SysIndexColumn> getByUserIdFilter(short type, String ... tenantIds) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap map = new HashMap();
        params.put("relationMap", map);
        try {
            Map authMap = this.authorityManager.getUserRightMap();
            ArrayNode array = this.ucFeignService.getCurrentUserAuthOrgLayout(ContextUtil.getCurrentUserId());
            if (BeanUtils.isNotEmpty((Object)array)) {
                HashSet<String> authOrgIdList = new HashSet<String>();
                for (JsonNode jsonNode : array) {
                    ObjectNode node = (ObjectNode)jsonNode;
                    authOrgIdList.add(node.get("orgId").asText());
                }
                authMap.put("auth_org", authOrgIdList);
            }
            params.put("relationMap", authMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params.put("objType", "indexColumn");
        params.put("isPublic", type);
        params.put("tenantIds", Arrays.asList(tenantIds));
        return ((SysIndexColumnDao)this.baseMapper).getByUserIdFilter(params);
    }

    public String parseTemplateHtml(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        ObjectNode json = this.parseTemplateJSON(sysIndexColumn, params);
        return json.get("html").asText();
    }

    private Class<?> getParameterTypes(String type) {
        Class claz = null;
        try {
            claz = type.equalsIgnoreCase("string") ? String.class : (type.equalsIgnoreCase("int") ? Integer.class : (type.equalsIgnoreCase("float") ? Float.class : (type.equalsIgnoreCase("double") ? Double.class : (type.equalsIgnoreCase("byte") ? Byte.class : (type.equalsIgnoreCase("short") ? Short.class : (type.equalsIgnoreCase("long") ? Long.class : (type.equalsIgnoreCase("boolean") ? Boolean.class : (type.equalsIgnoreCase("date") ? Date.class : String.class))))))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claz;
    }

    private String parserHtml(String html, SysIndexColumn sysIndexColumn, PageBean pageBean, Map<String, Object> params) throws Exception {
        if (StringUtil.isEmpty((String)html)) {
            return "";
        }
        Document doc = Jsoup.parseBodyFragment((String)html);
        Elements els = doc.body().children();
        if (BeanUtils.isEmpty((Object)els)) {
            return doc.body().html();
        }
        Element el = els.get(0);
        el.attr("template-alias", sysIndexColumn.getAlias());
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        for (String key : params.keySet()) {
            json.set(key, JsonUtil.toJsonNode((Object)params.get(key)));
        }
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            json.put("currentPage", pageBean.getPage());
            json.put("pageSize", pageBean.getPageSize());
        }
        el.attr("template-params", json.toString());
        html = doc.body().html();
        return html;
    }

    public String parseTemplateHtmlJSON(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        ObjectNode json = this.parseTemplateJSON(sysIndexColumn, params);
        return json.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectNode parseTemplateJSON(SysIndexColumn sysIndexColumn, Map<String, Object> params) throws Exception {
        Object data;
        Short colType;
        String html;
        block9: {
            String dataFrom = sysIndexColumn.getDataFrom();
            html = sysIndexColumn.getTemplateHtml();
            html = Base64.getFromBase64((String)html);
            colType = sysIndexColumn.getColType();
            short dataMode = sysIndexColumn.getDataMode();
            String dataParam = sysIndexColumn.getDataParam();
            data = null;
            try {
                Class<?>[] parameterTypes = this.getParameterTypes(dataParam, params);
                Object[] param = this.getDataParam(dataParam, params);
                if (SysIndexColumn.DATA_MODE_SERVICE == dataMode) {
                    data = this.getModelByHandler(dataFrom, param, parameterTypes);
                    break block9;
                }
                if (SysIndexColumn.DATA_MODE_QUERY == dataMode) {
                    String alias = sysIndexColumn.getDataFrom();
                    data = this.formFeignService.getQueryPage(alias);
                    break block9;
                }
                if (SysIndexColumn.DATA_MODE_WEBSERVICE == dataMode) {
                    data = this.callWebService(dataFrom);
                } else if (SysIndexColumn.DATA_MODE_RESTFUL != dataMode) {
                    // empty if block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Long height = BeanUtils.isEmpty((Object)sysIndexColumn.getColHeight()) ? 320L : sysIndexColumn.getColHeight();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("alias", sysIndexColumn.getAlias());
        model.put("title", sysIndexColumn.getName());
        model.put("url", sysIndexColumn.getColUrl());
        model.put("height", height);
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        if (BeanUtils.isNotEmpty((Object)colType) && (SysIndexColumn.COLUMN_TYPE_CHART == colType || SysIndexColumn.COLUMN_TYPE_CALENDAR == colType) && BeanUtils.isNotEmpty((Object)data)) {
            json.set("option", JsonUtil.toJsonNode((Object)data));
        }
        json.put("isRefresh", sysIndexColumn.getSupportRefesh());
        json.put("refreshTime", sysIndexColumn.getRefeshTime());
        json.put("show", sysIndexColumn.getShowEffect());
        json.put("type", colType);
        json.put("height", height);
        json.put("html", html);
        if (BeanUtils.isNotEmpty((Object)data)) {
            json.set("data", JsonUtil.toJsonNode((Object)data));
        }
        json.set("model", JsonUtil.toJsonNode(model));
        json.put("requestType", sysIndexColumn.getRequestType());
        json.put("dataParam", sysIndexColumn.getDataParam());
        json.put("dataFrom", sysIndexColumn.getDataFrom());
        return json;
    }

    private ArrayNode getArrayParams(String dataParam, Object[] param, Class<?>[] parameterTypes) {
        ObjectMapper mapper = JsonUtil.getMapper();
        ArrayNode array = mapper.createArrayNode();
        if (StringUtil.isNotEmpty((String)dataParam)) {
            try {
                JsonNode paramArray = JsonUtil.toJsonNode((String)dataParam);
                for (int i = 0; i < paramArray.size(); ++i) {
                    ObjectNode obj = (ObjectNode)paramArray.get(i);
                    obj.set("value", JsonUtil.toJsonNode((Object)param[i]));
                    obj.put("type", parameterTypes[i].getCanonicalName());
                    array.add((JsonNode)obj);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return array;
    }

    private String parseByStringTemplate(Object obj, String templateSource) throws TemplateException, IOException {
        Configuration cfg = new Configuration();
        cfg.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        StringTemplateLoader loader = new StringTemplateLoader();
        cfg.setTemplateLoader((TemplateLoader)loader);
        cfg.setClassicCompatible(true);
        loader.putTemplate("freemaker", templateSource);
        Template template = cfg.getTemplate("freemaker");
        StringWriter writer = new StringWriter();
        template.process(obj, (Writer)writer);
        return writer.toString();
    }

    private PageBean handerPageBean(Object data) {
        PageBean pageBean = null;
        try {
            if (data instanceof PageList) {
                pageBean = new PageBean();
                PageList pageList = (PageList)data;
                int page = (int)pageList.getPage();
                int pageSize = (int)pageList.getPageSize();
                pageBean.setPage(page);
                pageBean.setPageSize(pageSize);
            } else if (data instanceof IndexTabList) {
                IndexTabList indexTablist = (IndexTabList)data;
                pageBean = this.getIndexTabPageBean(indexTablist);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageBean;
    }

    private PageBean getIndexTabPageBean(IndexTabList indexTablist) {
        if (BeanUtils.isEmpty((Object)indexTablist)) {
            return null;
        }
        return indexTablist.getPageBean();
    }

    private Class<?>[] getParameterTypes(String dataParam, Map<String, Object> params) throws Exception {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return new Class[0];
        }
        JsonNode jary = JsonUtil.toJsonNode((String)dataParam);
        Class[] parameterTypes = new Class[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            JsonNode json = jary.get(i);
            String type = "string";
            if (BeanUtils.isNotEmpty((Object)json.get("type"))) {
                type = json.get("type").toString();
            }
            parameterTypes[i] = this.getParameterTypes(type);
        }
        return parameterTypes;
    }

    private Object[] getDataParam(String dataParam, Map<String, Object> params) {
        if (JsonUtil.isEmpty((Object)dataParam) || StringUtil.isEmpty((String)dataParam)) {
            return null;
        }
        ArrayNode jary = JsonUtil.getMapper().createArrayNode();
        Object[] args = new Object[jary.size()];
        for (int i = 0; i < jary.size(); ++i) {
            Object val;
            ObjectNode json = (ObjectNode)jary.get(i);
            String name = json.get("name").asText();
            String type = json.get("type").asText();
            String mode = json.get("mode").asText();
            String value = json.get("value").asText();
            Object o = value;
            if (mode.equalsIgnoreCase("1")) {
                o = params.get(name);
                if (JsonUtil.isEmpty((Object)o) && BeanUtils.isNotEmpty((Object)value)) {
                    o = value;
                }
            } else if (mode.equalsIgnoreCase("2")) {
                o = this.groovyScriptEngine.executeString(value, params);
            }
            args[i] = val = StringUtil.parserObject((Object)o, (String)type);
        }
        return args;
    }

    private Object getModelByHandler(String handler, Object[] args, Class<?>[] parameterTypes) throws Exception {
        Method invokeMethod;
        Object model = null;
        if (StringUtil.isEmpty((String)handler)) {
            return model;
        }
        int rtn = SysIndexColumnManagerImpl.isHandlerValidNoCmd(handler, parameterTypes);
        if (rtn != 0) {
            return model;
        }
        String[] aryHandler = handler.split("[.]");
        if (aryHandler == null) {
            return model;
        }
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = AppUtil.getBean((String)beanId);
        if (serviceBean == null) {
            return model;
        }
        if (args == null || args.length <= 0) {
            parameterTypes = new Class[]{};
        }
        if (BeanUtils.isEmpty((Object)(model = (invokeMethod = serviceBean.getClass().getDeclaredMethod(method, parameterTypes)).invoke(serviceBean, args)))) {
            model = null;
        }
        return model;
    }

    public static int isHandlerValidNoCmd(String handler, Class<?>[] parameterTypes) {
        if (handler.indexOf(".") == -1) {
            return -1;
        }
        String[] aryHandler = handler.split("[.]");
        String beanId = aryHandler[0];
        String method = aryHandler[1];
        Object serviceBean = null;
        try {
            serviceBean = AppUtil.getBean((String)beanId);
        }
        catch (Exception ex) {
            return -2;
        }
        if (serviceBean == null) {
            return -2;
        }
        try {
            Method invokeMethod = serviceBean.getClass().getMethod(method, parameterTypes);
            if (invokeMethod != null) {
                return 0;
            }
            return -3;
        }
        catch (NoSuchMethodException e) {
            return -3;
        }
        catch (Exception e) {
            return -4;
        }
    }

    @Override
    public SysIndexColumn getByColumnAlias(String alias) {
        SysIndexColumn column = ((SysIndexColumnDao)this.baseMapper).getByColumnAlias(alias);
        if (BeanUtils.isNotEmpty((Object)((Object)column))) {
            boolean hasRight = this.sysAuthUserManager.hasRights(column.getId());
            column.setDisplayRights(hasRight);
        }
        return column;
    }

    @Override
    public String getHtmlByColumnAlias(String alias, Map<String, Object> params) throws Exception {
        SysIndexColumn sysIndexColumn = this.getByColumnAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)sysIndexColumn))) {
            return "";
        }
        return this.parseTemplateHtmlJSON(sysIndexColumn, params);
    }

    @Override
    public String parserDesignHtml(String designHtml, List<SysIndexColumn> columnList) {
        if (StringUtil.isEmpty((String)designHtml)) {
            return null;
        }
        Document doc = Jsoup.parseBodyFragment((String)designHtml);
        Elements els = doc.select("[template-alias]");
        for (Element el : els) {
            String value = el.attr("template-alias");
            String h = this.getSysIndexColumn(value, columnList);
            Element parent = el.parent();
            el.remove();
            parent.append(h);
        }
        designHtml = doc.body().html();
        return designHtml;
    }

    private String getSysIndexColumn(String alias, List<SysIndexColumn> columnList) {
        for (SysIndexColumn sysIndexColumn : columnList) {
            if (!alias.equals(sysIndexColumn.getAlias())) continue;
            return sysIndexColumn.getTemplateHtml();
        }
        return "";
    }

    @Override
    public Map<String, List<SysIndexColumn>> getColumnMap(List<SysIndexColumn> columnList) throws Exception {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(CategoryConstants.CAT_INDEX_COLUMN.key());
        SysType type = new SysType();
        type.setId(sysCategory.getId());
        type.setName(sysCategory.getName());
        type.setParentId("-1");
        type.setTypeKey(sysCategory.getGroupKey());
        List sysTypeList = this.sysTypeManager.getByGroupKey(CategoryConstants.CAT_INDEX_COLUMN.key());
        sysTypeList.add(type);
        HashMap<String, String> typeIdName = new HashMap<String, String>();
        for (SysType t : sysTypeList) {
            typeIdName.put(t.getId(), t.getName());
        }
        LinkedHashMap<String, List<SysIndexColumn>> map1 = new LinkedHashMap<String, List<SysIndexColumn>>();
        for (SysIndexColumn sysIndexColumn : columnList) {
            List<SysIndexColumn> list;
            String name;
            String catalog = sysIndexColumn.getCatalog();
            if (typeIdName.keySet().contains(catalog)) {
                name = (String)typeIdName.get(catalog);
                list = (List)map1.get(name);
                if (BeanUtils.isEmpty((Object)list)) {
                    list = new ArrayList();
                }
                list.add(sysIndexColumn);
                map1.put(name, list);
                continue;
            }
            name = "\u9ed8\u8ba4\u680f\u76ee";
            list = (ArrayList<SysIndexColumn>)map1.get(name);
            if (BeanUtils.isEmpty((Object)list)) {
                list = new ArrayList<SysIndexColumn>();
            }
            list.add(sysIndexColumn);
            map1.put(name, list);
        }
        return map1;
    }

    @Override
    public Map<String, List<Map<String, Object>>> getColumnMap2(List<SysIndexColumn> columnList) {
        LinkedHashMap<String, List<Map<String, Object>>> result = new LinkedHashMap<String, List<Map<String, Object>>>();
        ArrayList publicList = new ArrayList();
        ArrayList privateList = new ArrayList();
        if (BeanUtils.isNotEmpty(columnList)) {
            for (SysIndexColumn item : columnList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", item.getName());
                map.put("alias", item.getAlias());
                if ("-1".equals(item.getTenantId())) {
                    publicList.add(map);
                    continue;
                }
                privateList.add(map);
            }
        }
        result.put("\u516c\u6709\u680f\u76ee", publicList);
        result.put("\u79c1\u6709\u680f\u76ee", privateList);
        return result;
    }

    @Override
    public Boolean isExistAlias(String alias, String id) {
        if (id == null || "0".equals(id)) {
            id = null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("alias", alias);
        params.put("id", id);
        Integer count = ((SysIndexColumnDao)this.baseMapper).isExistAlias(params);
        return count > 0;
    }

    public Object callWebService(String alias) throws Exception {
        try {
            HashMap params = new HashMap();
            InvokeResult result = this.serviceClient.invoke(alias, params);
            ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
            if (StringUtil.isNotEmpty((String)result.getJson())) {
                jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)result.getJson());
                try {
                    return JsonUtil.toJsonNode((Object)jsonObject.get("list"));
                }
                catch (Exception e) {
                    return jsonObject.get("list").asText();
                }
            }
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonUtil.getMapper().createObjectNode();
        }
    }

    @Override
    public List<SysIndexColumn> batchGetColumnAliases(String aliases) {
        if (StringUtil.isEmpty((String)aliases)) {
            return new ArrayList<SysIndexColumn>();
        }
        String[] ary = aliases.split(",");
        List hasRightsColIds = this.sysAuthUserManager.getAuthorizeIdsByUserMap("indexColumn");
        StringBuffer stringBuffer = new StringBuffer(64);
        hasRightsColIds.forEach(v -> stringBuffer.append("'" + v + "',"));
        return ((SysIndexColumnDao)this.baseMapper).batchGetByColumnAliases(Arrays.asList(ary), String.join((CharSequence)",", stringBuffer.substring(0, stringBuffer.length() - 1)));
    }

    @Override
    @Transactional
    public void createAndAuth(SysIndexColumn sysIndexColumn) throws IOException {
        this.create((Model)sysIndexColumn);
        String ownerNameJson = " [{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\",\"checked\":true}]";
        this.sysAuthUserManager.saveRights(sysIndexColumn.getId(), "indexColumn", ownerNameJson);
    }

    @Override
    public List<SysIndexColumn> getAllByLayoutType(QueryFilter queryFilter) {
        return ((SysIndexColumnDao)this.baseMapper).selectList((Wrapper)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public void deleteByNewsParentId(String parentId) {
        this.sysIndexColumnDao.deleteByNewsParentId(parentId);
    }

    @Override
    public String exportColumn(List<String> ids) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            return "";
        }
        List sysIndexColumns = ((SysIndexColumnDao)this.baseMapper).selectBatchIds(ids);
        if (BeanUtils.isEmpty((Object)sysIndexColumns)) {
            return "";
        }
        return JsonUtil.toJson((Object)sysIndexColumns);
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String fileStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "indexColumns.json"));
            SaaSConfig saaSConfig = (SaaSConfig)AppUtil.getBean(SaaSConfig.class);
            boolean enable = saaSConfig.isEnable();
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            for (Object o : list) {
                SysIndexColumn column = (SysIndexColumn)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexColumn.class));
                SysIndexColumn byAlias = ((SysIndexColumnDao)this.baseMapper).getByColumnAlias(column.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (byAlias.getId().equals(column.getId())) {
                        ((SysIndexColumnDao)this.baseMapper).updateById((Object)column);
                        continue;
                    }
                    throw new BaseException("\u680f\u76ee\u5e03\u5c40\u522b\u540d\u3010" + column.getAlias() + "\u3011\u5df2\u5b58\u5728");
                }
                column.setId(UniqueIdUtil.getSuid());
                if (enable) {
                    column.setTenantId(null);
                }
                ((SysIndexColumnDao)this.baseMapper).insert((Object)column);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }
}

