/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.dataway;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.util.DataSourceUtil;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DatawayDataSourceConfig {
    private static final Logger log = LoggerFactory.getLogger(DatawayDataSourceConfig.class);
    private static Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();

    public DataSource getDataSource(String alias) {
        DataSource dataSource = null;
        try {
            if (StringUtils.isEmpty((CharSequence)alias)) {
                throw new ApplicationException("\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u7a7a");
            }
            if (dataSourceMap.containsKey(alias)) {
                dataSource = dataSourceMap.get(alias);
            } else {
                dataSource = DataSourceUtil.getDataSourceByAlias(alias);
                dataSourceMap.put(alias, dataSource);
            }
            if (dataSource == null) {
                throw new ApplicationException("\u3010" + alias + "\u3011\u6570\u636e\u6e90\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (Exception e) {
            throw new ApplicationException("\u521b\u5efa\u8fde\u63a5\u5931\u8d25");
        }
        return dataSource;
    }
}

