/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.persistence.manager.impl;

import com.artfess.application.model.AppModel;
import com.artfess.application.model.AppModelList;
import com.artfess.application.persistence.dao.AppModelDao;
import com.artfess.application.persistence.manager.AppModelManager;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.sysConfig.persistence.dao.SysAuthUserDao;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysAuthUser;
import com.artfess.sysConfig.persistence.model.SysType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="appModelManager")
public class AppModelManagerImpl
extends BaseManagerImpl<AppModelDao, AppModel>
implements AppModelManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    SysAuthUserDao sysAuthUserDao;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public List<AppModel> getByTypeId(String typeId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.eq((Object)"TYPE_ID_", (Object)typeId)).eq((Object)"ENABLE_", (Object)1);
        });
        queryWrapper.orderByAsc((Object)"SN_");
        queryWrapper.orderByDesc((Object)"CREATE_TIME_");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        AppModelList appModelList = new AppModelList();
        for (String id : ids) {
            AppModel appModel = (AppModel)this.get((Serializable)((Object)id));
            SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)appModel.getTypeId()));
            if (sysType == null && (sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "mrfl")) == null) {
                sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "default");
            }
            appModel.setTypeKey(sysType.getTypeKey());
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("authorize_id_", id);
            List sysAuthUserList = this.sysAuthUserDao.selectByMap(condition);
            for (SysAuthUser sysAuthUser : sysAuthUserList) {
                String code;
                CommonResult result;
                String rightType = sysAuthUser.getRightType();
                String ownerId = sysAuthUser.getOwnerId();
                if ("user".equals(rightType)) {
                    result = this.ucFeignService.getUserById(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)result)) continue;
                    JsonNode userNode = (JsonNode)result.getValue();
                    String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    sysAuthUser.setOwnerCode(account);
                    continue;
                }
                if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)orgObjNode)) continue;
                    String code2 = orgObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code2);
                    continue;
                }
                if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)result)) continue;
                    ObjectNode posObjNode = (ObjectNode)result.getValue();
                    code = posObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code);
                    continue;
                }
                if (!"role".equals(rightType) || !BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getRoleByIdOrCode(ownerId)))) continue;
                ObjectNode roleObjNode = (ObjectNode)result.getValue();
                code = roleObjNode.get("code").asText();
                sysAuthUser.setOwnerCode(code);
            }
            appModel.setSysAuthUserList(sysAuthUserList);
            appModelList.addAppModel(appModel);
        }
        try {
            String xml = JAXBUtil.marshall((Object)appModelList, AppModelList.class);
            map.put("appModels.portal.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "appModels.portal.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            AppModelList list = (AppModelList)JAXBUtil.unmarshall((String)xml, AppModelList.class);
            List<AppModel> appModelList = list.getAppModelList();
            for (AppModel appModel : appModelList) {
                this.importData(appModel);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    private void importData(AppModel appModel) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"name_", (Object)appModel.getName());
        List appModelList = ((AppModelDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (appModelList != null && !appModelList.isEmpty()) {
            ThreadMsgUtil.addMapMsg2((String)"appModelsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", appModel.getName() + ""));
            return;
        }
        String appId = UniqueIdUtil.getSuid();
        appModel.setId(appId);
        SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", appModel.getTypeKey());
        if (sysType == null && (sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "mrfl")) == null) {
            sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("appType", "default");
        }
        appModel.setTypeId(sysType.getId());
        appModel.setTypeName(sysType.getName());
        List<SysAuthUser> sysAuthUserList = appModel.getSysAuthUserList();
        if (BeanUtils.isEmpty(sysAuthUserList)) {
            this.sysAuthUserManager.createDefault(appId);
        } else {
            for (SysAuthUser sysAuthUser : sysAuthUserList) {
                String ownerName;
                String ownerId;
                CommonResult result;
                String ownerName2;
                String ownerId2;
                String authId = UniqueIdUtil.getSuid();
                sysAuthUser.setId(authId);
                sysAuthUser.setAuthorizeId(appId);
                String rightType = sysAuthUser.getRightType();
                String ownerCode = sysAuthUser.getOwnerCode();
                if ("user".equals(rightType)) {
                    JsonNode userNode = this.ucFeignService.getUser(ownerCode, null);
                    if (BeanUtils.isNotEmpty((Object)userNode)) {
                        ownerId2 = JsonUtil.getString((JsonNode)userNode, (String)"id");
                        ownerName2 = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)orgObjNode)) {
                        ownerId2 = orgObjNode.get("id").asText();
                        ownerName2 = orgObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)result)) {
                        ObjectNode posObjNode = (ObjectNode)result.getValue();
                        ownerId = posObjNode.get("id").asText();
                        ownerName = posObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("role".equals(rightType) && BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getRoleByIdOrCode(ownerCode)))) {
                    ObjectNode roleObjNode = (ObjectNode)result.getValue();
                    ownerId = roleObjNode.get("id").asText();
                    ownerName = roleObjNode.get("name").asText();
                    sysAuthUser.setOwnerId(ownerId);
                    sysAuthUser.setOwnerName(ownerName);
                }
                this.sysAuthUserDao.insert((Object)sysAuthUser);
            }
        }
        this.create((Model)appModel);
        ThreadMsgUtil.addMapMsg2((String)"appModelsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", appModel.getName() + ""));
    }
}

