/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.filter;

import com.artfess.base.exception.ApplicationException;
import com.artfess.dataShare.http.RequestWrapper;
import com.artfess.redis.util.RedisUtil;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class HttpServletRequestFilter
implements Filter {
    @Resource
    private RedisUtil redisUtil;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException, ApplicationException {
        RequestWrapper requestWrapper = null;
        if (servletRequest instanceof HttpServletRequest) {
            requestWrapper = new RequestWrapper((HttpServletRequest)servletRequest);
        }
        if (null == requestWrapper) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
        }
    }

    public void destroy() {
        super.destroy();
    }
}

