/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterDataCountDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterDataCountManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTempDataLogManager;
import com.artfess.dataShare.dataCollect.model.BizClusterDataCount;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTempDataLog;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.manager.BizSchedulerCollectTimesManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizClusterDataCountManagerImpl
extends BaseManagerImpl<BizClusterDataCountDao, BizClusterDataCount>
implements BizClusterDataCountManager {
    @Resource
    BizSchedulerCollectTimesManager schedulerCollectTimesManager;
    @Resource
    BizClusterTableManager tableManager;
    @Resource
    BizOdsTableManager odsTableManager;
    @Resource
    BizClusterInfoModeManager infoModeManager;
    @Resource
    BizClusterDataCountManager dataCountManager;
    @Resource
    BizClusterTempDataLogManager tempDataLogManager;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void calcClusterInfoDataDay() throws Exception {
        List listInfo = this.infoModeManager.list();
        for (BizClusterInfoMode item : listInfo) {
            String sql = "select t.* from (select company_name_,sys_name_,sys_code_,name_,code_,table_name_,count(src_id_) change_num_,\nsum(case when DATA_TYPE_=1 then 1 else 0 end) add_num_,\nsum(case when DATA_TYPE_=2 then 1 else 0 end) update_num_,\nsum(case when DATA_TYPE_=3 then 1 else 0 end) del_num_,now(),1,date_format(now(),'%Y%m%d')\nfrom BIZ_CLUSTER_TEMP_DATA where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')\ngroup by company_name_,sys_name_,sys_code_,name_,code_,table_name_\n) t";
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)item.getDatabaseAlias());
            List listMap = template.queryForList(sql);
            if (listMap.size() == 0) {
                BizClusterDataCount dataCount = new BizClusterDataCount();
                dataCount.setCompanyName(item.getCompanyName());
                dataCount.setSysName(item.getSysName());
                dataCount.setSysCode(item.getSysCode());
                dataCount.setChangeNum(0L);
                dataCount.setAddNum(0L);
                dataCount.setUpdateNum(0L);
                dataCount.setDelNum(0L);
                dataCount.setCreateDate(LocalDate.now());
                dataCount.setCountDate(LocalDate.now());
                this.dataCountManager.save((Object)dataCount);
            }
            ArrayList<BizClusterDataCount> list = new ArrayList<BizClusterDataCount>();
            for (Map map : listMap) {
                BizClusterDataCount dataCount = new BizClusterDataCount();
                dataCount.setCompanyName(map.get("company_name_").toString());
                dataCount.setSysName(map.get("sys_name_").toString());
                dataCount.setSysCode(map.get("sys_code_").toString());
                dataCount.setTableName(map.get("table_name_").toString());
                dataCount.setName(map.get("name_").toString());
                dataCount.setCode(map.get("code_").toString());
                dataCount.setChangeNum(Long.parseLong(map.get("change_num_").toString()));
                dataCount.setAddNum(Long.parseLong(map.get("add_num_").toString()));
                dataCount.setUpdateNum(Long.parseLong(map.get("update_num_").toString()));
                dataCount.setDelNum(Long.parseLong(map.get("del_num_").toString()));
                dataCount.setCreateDate(LocalDate.now());
                dataCount.setCountDate(LocalDate.now());
                list.add(dataCount);
            }
            if (list.size() > 0) {
                this.dataCountManager.saveBatch(list);
            }
            List listTemp = template.queryForList("select * from BIZ_CLUSTER_TEMP_DATA where date_format(create_time_,'%Y%m%d')=date_format(now(),'%Y%m%d')");
            ArrayList<BizClusterTempDataLog> listLog = new ArrayList<BizClusterTempDataLog>();
            ArrayList<String> tempIds = new ArrayList<String>();
            for (Map map : listTemp) {
                tempIds.add(map.get("id_").toString());
                BizClusterTempDataLog dataCountLog = new BizClusterTempDataLog();
                dataCountLog.setCompanyName(map.get("company_name_").toString());
                dataCountLog.setSysName(map.get("sys_name_").toString());
                dataCountLog.setSysCode(map.get("sys_code_").toString());
                dataCountLog.setName(map.get("name_").toString());
                dataCountLog.setCode(map.get("code_").toString());
                dataCountLog.setTableName(map.get("table_name_").toString());
                dataCountLog.setDataType(Integer.parseInt(map.get("data_type_").toString()));
                dataCountLog.setSrcId(map.get("SRC_ID_").toString());
                dataCountLog.setCreateTime(LocalDateTime.now());
                listLog.add(dataCountLog);
            }
            if (listLog.size() > 0) {
                this.tempDataLogManager.saveBatch(listLog);
            }
            String updateSql = "update BIZ_CLUSTER_DATA_COUNT set TOTAL_NUM_=? where  COUNT_DATE_=date_format(now(),'%Y%m%d') and table_name_= ?";
            String updateTableTotalSql = "update BIZ_CLUSTER_TABLE set TOTAL_NUM_=? where TABLE_NAME_EN_= ?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            List<BizClusterTable> tableList = this.tableManager.queryTableByClusterId(item.getId());
            for (BizClusterTable table : tableList) {
                if (!"1".equals(table.getDeployed())) continue;
                String queryTableCount = "select count(*) from " + table.getTableNameEn();
                Integer count = (Integer)template.queryForObject(queryTableCount, Integer.class);
                Object[] obj = new Object[]{count, table.getTableNameEn()};
                paramList.add(obj);
            }
            if (paramList.size() > 0) {
                this.jdbcTemplate.batchUpdate(updateSql, paramList);
                this.jdbcTemplate.batchUpdate(updateTableTotalSql, paramList);
            }
            if (tempIds.size() <= 0) continue;
            template.execute("delete from BIZ_CLUSTER_TEMP_DATA where id_ in ('" + tempIds.stream().collect(Collectors.joining("','")) + "')");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void calcClusterGatherOds() throws Exception {
        JdbcTemplate odsTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"ods");
        List listInfo = this.infoModeManager.list();
        ArrayList collectTimesList = new ArrayList();
        for (BizClusterInfoMode item : listInfo) {
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)item.getDatabaseAlias());
            List listTemp = template.queryForList("select table_name_,data_type_,GROUP_CONCAT(src_id_) ids from BIZ_CLUSTER_COLLECT_DATA group by table_name_,data_type_ order by table_name_");
            ArrayList<String> delTableName = new ArrayList<String>();
            for (Map map : listTemp) {
                String tableName = map.get("table_name_").toString();
                String queryTableDataSql = "SELECT count(1) FROM information_schema.tables WHERE table_schema = '" + item.getDatabaseName() + "' AND table_name = '" + tableName + "'";
                Integer isExtistsTable = (Integer)template.queryForObject(queryTableDataSql, Integer.class);
                if (isExtistsTable != 0) continue;
                delTableName.add(tableName);
            }
            if (delTableName.size() > 0) {
                listTemp = listTemp.stream().filter(p -> !delTableName.contains(p.get("table_name_"))).collect(Collectors.toList());
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.last(" limit 1");
            BizOdsTable table = (BizOdsTable)((Object)this.odsTableManager.getOne((Wrapper)queryWrapper));
            if (null == table) continue;
            ArrayList<String> tempIds = new ArrayList<String>();
            int insertNum = 0;
            boolean updateNum = false;
            int delNum = 0;
            for (Map map : listTemp) {
                List queryTableData;
                String queryTableDataSql;
                String ids = map.get("ids").toString();
                if (ids.indexOf(",") > 0) {
                    tempIds.addAll(Arrays.asList(ids.split(",")));
                }
                String tableName = map.get("table_name_").toString();
                String dataType = map.get("data_type_").toString();
                if ("1".equalsIgnoreCase(dataType)) {
                    queryTableDataSql = "select * from " + tableName + " where id_ in ('" + ids.replace(",", "','") + "')";
                    queryTableData = template.queryForList(queryTableDataSql);
                    ArrayList<Object[]> param = new ArrayList<Object[]>();
                    String insertSql = "insert into ods_" + tableName;
                    for (int i = 0; i < queryTableData.size(); ++i) {
                        Map tableData = (Map)queryTableData.get(i);
                        tableData.remove("REF_ID_");
                        tableData.remove("F_form_data_rev_");
                        tableData.remove("form_data_rev_");
                        if (i == 0) {
                            String field = "";
                            String val = "";
                            for (String key : tableData.keySet()) {
                                key = key.replaceFirst("F_", "");
                                field = field + key + ",";
                                val = val + "?,";
                            }
                            insertSql = insertSql + "(" + field.substring(0, field.length() - 1) + ") values(" + val.substring(0, val.length() - 1) + ")";
                            param.add(tableData.values().toArray());
                            continue;
                        }
                        param.add(tableData.values().toArray());
                    }
                    if (param.size() <= 0) continue;
                    odsTemplate.batchUpdate(insertSql, param);
                    insertNum = param.size();
                    continue;
                }
                if ("2".equalsIgnoreCase(dataType)) {
                    queryTableDataSql = "select * from " + tableName + " where id_ in ('" + ids.replace(",", "','") + "')";
                    queryTableData = template.queryForList(queryTableDataSql);
                    ArrayList<String> sql = new ArrayList<String>();
                    for (int i = 0; i < queryTableData.size(); ++i) {
                        Map tableData = (Map)queryTableData.get(i);
                        String id = tableData.get("id_").toString();
                        String updateSql = "update ods_" + tableName + " set ";
                        for (String key : tableData.keySet()) {
                            if ("REF_ID_".equalsIgnoreCase(key) || "F_form_data_rev_".equalsIgnoreCase(key) || "form_data_rev_".equalsIgnoreCase(key) || "id_".equalsIgnoreCase(key)) continue;
                            String newKey = key.replaceFirst("F_", "");
                            if (null == tableData.get(key)) continue;
                            updateSql = updateSql + newKey + "= '" + tableData.get(key) + "',";
                        }
                        if (updateSql.indexOf(",") > 1) {
                            updateSql = updateSql.substring(0, updateSql.length() - 1);
                        }
                        updateSql = updateSql + " where id_= '" + id + "'";
                        sql.add(updateSql);
                    }
                    if (sql.size() <= 0) continue;
                    String[] updateSql = new String[sql.size()];
                    odsTemplate.batchUpdate(sql.toArray(updateSql));
                    insertNum = sql.size();
                    continue;
                }
                if (!"3".equalsIgnoreCase(dataType) || !StringUtil.isNotEmpty((String)ids)) continue;
                odsTemplate.execute("update ods_" + tableName + " set IS_DELE_=1 where id_ in ('" + ids.replace(",", "','") + "')");
                delNum = tempIds.size();
            }
            if (collectTimesList.size() > 0) {
                this.schedulerCollectTimesManager.saveBatch(collectTimesList);
            }
            if (tempIds.size() <= 0) continue;
            template.execute("delete from biz_cluster_collect_data where id_ in ('" + tempIds.stream().collect(Collectors.joining("','")) + "')");
        }
        String updateTableTotalSql = "update BIZ_ODS_CATALOGS_TABLE set TOTAL_NUM_=? where TABLE_NAME_EN_= ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        List<BizOdsTable> tableList = this.odsTableManager.queryDeployed();
        for (BizOdsTable table : tableList) {
            String queryTableCount = "select count(*) from " + table.getTableNameEn();
            Integer count = (Integer)odsTemplate.queryForObject(queryTableCount, Integer.class);
            Object[] obj = new Object[]{count, table.getTableNameEn()};
            paramList.add(obj);
        }
        if (paramList.size() > 0) {
            this.jdbcTemplate.batchUpdate(updateTableTotalSql, paramList);
        }
    }
}

