/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.util;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class MdcThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final long serialVersionUID = 1L;

    public void execute(Runnable runnable) {
        Map context = MDC.getCopyOfContextMap();
        super.execute(() -> this.run(runnable, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Runnable runnable, Map<String, String> context) {
        if (context != null) {
            try {
                MDC.setContextMap(context);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            runnable.run();
        }
        finally {
            MDC.clear();
        }
    }
}

