/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import com.artfess.base.util.AppUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.Condition;
import org.activiti.engine.impl.bpmn.behavior.GatewayActivityBehavior;
import org.activiti.engine.impl.entity.GatewayUnmetJoinEventModel;
import org.activiti.engine.impl.event.GatewayUnmetJoinEvent;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

public class InclusiveGatewayActivityBehavior
extends GatewayActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((String)InclusiveGatewayActivityBehavior.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(ActivityExecution execution) throws Exception {
        execution.inactivate();
        this.lockConcurrentRoot(execution);
        PvmActivity activity = execution.getActivity();
        if (!this.activeConcurrentExecutionsExist(execution)) {
            if (log.isDebugEnabled()) {
                log.debug("inclusive gateway '{}' activates", (Object)activity.getId());
            }
            List joinedExecutions = execution.findInactiveConcurrentExecutions(activity);
            String defaultSequenceFlow = (String)execution.getActivity().getProperty("default");
            ArrayList<PvmTransition> transitionsToTake = new ArrayList<PvmTransition>();
            for (PvmTransition outgoingTransition : execution.getActivity().getOutgoingTransitions()) {
                Condition condition;
                if (defaultSequenceFlow != null && outgoingTransition.getId().equals(defaultSequenceFlow) || (condition = (Condition)outgoingTransition.getProperty("condition")) != null && !condition.evaluate(null, (DelegateExecution)execution)) continue;
                transitionsToTake.add(outgoingTransition);
            }
            if (!transitionsToTake.isEmpty()) {
                execution.takeAll(transitionsToTake, joinedExecutions);
                return;
            } else {
                if (defaultSequenceFlow == null) throw new ActivitiException("No outgoing sequence flow of the inclusive gateway '" + execution.getActivity().getId() + "' could be selected for continuing the process");
                PvmTransition defaultTransition = execution.getActivity().findOutgoingTransition(defaultSequenceFlow);
                if (defaultTransition == null) throw new ActivitiException("Default sequence flow '" + defaultSequenceFlow + "' could not be not found");
                execution.take(defaultTransition);
            }
            return;
        } else {
            GatewayUnmetJoinEventModel model = new GatewayUnmetJoinEventModel(activity, execution, "inclusiveGateway");
            GatewayUnmetJoinEvent event = new GatewayUnmetJoinEvent(model);
            AppUtil.publishEvent((ApplicationEvent)event);
            if (!log.isDebugEnabled()) return;
            log.debug("Inclusive gateway '{}' does not activate", (Object)activity.getId());
        }
    }

    List<? extends ActivityExecution> getLeaveExecutions(ActivityExecution parent) {
        ArrayList<Object> executionlist = new ArrayList<Object>();
        List subExecutions = parent.getExecutions();
        if (subExecutions.isEmpty()) {
            executionlist.add(parent);
        } else {
            for (ActivityExecution concurrentExecution : subExecutions) {
                executionlist.addAll(this.getLeaveExecutions(concurrentExecution));
            }
        }
        return executionlist;
    }

    public boolean activeConcurrentExecutionsExist(ActivityExecution execution) {
        PvmActivity activity = execution.getActivity();
        if (execution.isConcurrent()) {
            for (ActivityExecution activityExecution : this.getLeaveExecutions(execution.getParent())) {
                if (!activityExecution.isActive() || activityExecution.getId().equals(execution.getId())) continue;
                boolean reachable = false;
                TransitionImpl pvmTransition = ((ExecutionEntity)activityExecution).getTransitionBeingTaken();
                reachable = pvmTransition != null ? this.isReachable(pvmTransition.getDestination(), activity, new HashSet<PvmActivity>()) : this.isReachable(activityExecution.getActivity(), activity, new HashSet<PvmActivity>());
                if (!reachable) continue;
                if (log.isDebugEnabled()) {
                    log.debug("an active concurrent execution found: '{}'", (Object)activityExecution.getActivity());
                }
                return true;
            }
        } else if (execution.isActive()) {
            if (log.isDebugEnabled()) {
                log.debug("an active concurrent execution found: '{}'", (Object)execution.getActivity());
            }
            return true;
        }
        return false;
    }

    protected boolean isReachable(PvmActivity srcActivity, PvmActivity targetActivity, Set<PvmActivity> visitedActivities) {
        if (srcActivity.getOutgoingTransitions().isEmpty()) {
            visitedActivities.add(srcActivity);
            if (!(srcActivity.getParent() instanceof PvmActivity)) {
                return false;
            }
            srcActivity = (PvmActivity)srcActivity.getParent();
        }
        if (srcActivity.equals(targetActivity)) {
            return true;
        }
        visitedActivities.add(srcActivity);
        List transitionList = srcActivity.getOutgoingTransitions();
        if (transitionList != null && !transitionList.isEmpty()) {
            for (PvmTransition pvmTransition : transitionList) {
                boolean reachable;
                PvmActivity destinationActivity = pvmTransition.getDestination();
                if (destinationActivity == null || visitedActivities.contains(destinationActivity) || !(reachable = this.isReachable(destinationActivity, targetActivity, visitedActivities))) continue;
                return true;
            }
        }
        return false;
    }
}

