/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.util.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public class JVMThreadUtils {
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public static int getDaemonThreadCount() {
        return threadMXBean.getDaemonThreadCount();
    }

    public static int getThreadCount() {
        return threadMXBean.getThreadCount();
    }

    public static int getPeakThreadCount() {
        return threadMXBean.getPeakThreadCount();
    }

    public static int getAndResetPeakThreadCount() {
        int count = threadMXBean.getPeakThreadCount();
        JVMThreadUtils.resetPeakThreadCount();
        return count;
    }

    public static void resetPeakThreadCount() {
        threadMXBean.resetPeakThreadCount();
    }

    public static int getDeadLockedThreadCount() {
        try {
            long[] deadLockedThreadIds = threadMXBean.findDeadlockedThreads();
            if (deadLockedThreadIds == null) {
                return 0;
            }
            return deadLockedThreadIds.length;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        while (true) {
            System.out.println("=======================================================================");
            System.out.println("getDaemonThreadCount: " + JVMThreadUtils.getDaemonThreadCount());
            System.out.println("getNonHeapMemoryUsage: " + JVMThreadUtils.getThreadCount());
            System.out.println("getPeakThreadCountAndReset: " + JVMThreadUtils.getAndResetPeakThreadCount());
            System.out.println("getDeadLockedThreadCount: " + JVMThreadUtils.getDeadLockedThreadCount());
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

