import { url } from '@/tripartite/buildBigScreen/src/config';
import request from '../axios'
import req from '@/request.js'
const report = window.context.report
export const getList = (params) => request({
  url: url + 'bigScreen/bladeVisual/v1/listJson',
  method: 'post',
  params: params
});



export const copyObj = (id) => request({
  url: url + '/visual/copy',
  method: 'post',
  params: {
    id: id
  }
});

export const getCategory = (params) => request({
  url: url + '/category/list',
  method: 'get',
  params: params
});

export const getObj = (id) => {
  return new Promise((resolve, reject) => {
    req.get(report + `bigScreen/bladeVisual/v1/get/${id}`).then(
      resp => {
        resolve(resp.data)
      },
      error => {
        reject(error)
      }
    )
  })
};

export const uploadImg = (file) => request({
  url: url + '/visual/put-file',
  method: 'post',
  data: 'file=' + file,
  headers: { "Content-Type": "multipart/form-data" }
});

export const addObj = (data) => request({
  url: url + '/visual/save',
  method: 'post',
  data: {
    visual: {
      password: data.password,
      category: data.category,
      status: data.status,
      title: data.title,
    },
    config: {
      detail: JSON.stringify({
        name: data.title,
        width: data.width,
        height: data.height,
        scale: 1,
        backgroundImage: '/img/bg/bg1.png',
        url: '',
        mark: {},
        gradeShow: false,
        gradeLen: 30,
      }),
      component: '[]'
    },
  }
});

export const updateComponent = (data) => {
  return new Promise((resolve, reject) => {
    req.post(report + `bigScreen/bladeVisual/v1/updateBladeVisualConfigVo`, data).then(
      resp => {
        resolve(resp.data)
      },
      error => {
        reject(error)
      }
    )
  })
}

export const updateObj = (data) => request({
  url: url + '/visual/update',
  method: 'post',
  data: {
    "visual": {
      "id": data.id,
      "password": data.password,
      "category": data.category,
      "status": data.status,
      "title": data.title,
    }
  }
});

export const delObj = (id) => request({
  url: url + '/visual/remove',
  method: 'post',
  params: {
    ids: id
  }
});